/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection.buffer;

import com.jn.langx.io.Rewindable;
import com.jn.langx.util.collection.buffer.exception.InvalidMarkException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

public abstract class Buffer<BF extends Buffer>
implements Rewindable {
    private long mark = -1L;
    private long position = 0L;
    private long limit;
    private long capacity;

    protected Buffer(long mark, long pos, long lim, long cap) {
        if (cap < 0L) {
            throw new IllegalArgumentException();
        }
        this.capacity = cap;
        this.limit(lim);
        this.position(pos);
        if (mark >= 0L) {
            if (mark > pos) {
                throw new IllegalArgumentException();
            }
            this.mark = mark;
        }
    }

    public final long capacity() {
        return this.capacity;
    }

    public final long position() {
        return this.position;
    }

    public final BF position(long newPosition) {
        if (newPosition > this.limit || newPosition < 0L) {
            throw new IllegalArgumentException();
        }
        this.position = newPosition;
        if (this.mark > this.position) {
            this.mark = -1L;
        }
        return (BF)this;
    }

    protected final long checkIndex(long i) {
        if (i < 0L || i >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return i;
    }

    public final long limit() {
        return this.limit;
    }

    public final BF limit(long newLimit) {
        if (newLimit > this.capacity || newLimit < 0L) {
            throw new IllegalArgumentException();
        }
        this.limit = newLimit;
        if (this.position > this.limit) {
            this.position = this.limit;
        }
        if (this.mark > this.limit) {
            this.mark = -1L;
        }
        return (BF)this;
    }

    public final BF mark() {
        this.mark = this.position;
        return (BF)this;
    }

    public final BF reset() {
        long m = this.mark;
        if (m < 0L) {
            throw new InvalidMarkException();
        }
        this.position = m;
        return (BF)this;
    }

    public BF clear() {
        this.position = 0L;
        this.limit = this.capacity;
        this.mark = -1L;
        return (BF)this;
    }

    public BF flip() {
        this.limit = this.position;
        this.position = 0L;
        this.mark = -1L;
        return (BF)this;
    }

    public BF rewind() {
        this.position = 0L;
        this.mark = -1L;
        return (BF)this;
    }

    public final long remaining() {
        return this.limit - this.position;
    }

    public final boolean hasRemaining() {
        return this.position < this.limit;
    }

    protected final long nextGetIndex() {
        if (this.position >= this.limit) {
            throw new BufferUnderflowException();
        }
        return this.position++;
    }

    protected final long nextGetIndex(long nb) {
        if (this.limit - this.position < nb) {
            throw new BufferUnderflowException();
        }
        long p = this.position;
        this.position += nb;
        return p;
    }

    protected final long nextPutIndex() {
        if (this.position >= this.limit) {
            throw new BufferOverflowException();
        }
        return this.position++;
    }

    public abstract boolean isReadOnly();

    public abstract boolean hasArray();

    public abstract Object array();

    public abstract long arrayOffset();
}

