/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.function.Supplier;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class WrappedNonAbsentMap<K, V>
implements Map<K, V> {
    private Map<K, V> delegate;
    private Supplier<K, V> supplier;

    public WrappedNonAbsentMap(@NonNull Map<K, V> map, @NonNull Supplier<K, V> supplier) {
        this.delegate = map;
        this.setSupplier(supplier);
    }

    private void setSupplier(Supplier<K, V> supplier) {
        Preconditions.checkNotNull(supplier);
        this.supplier = supplier;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return Emptys.isEmpty(this.delegate);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    public V get(Object key, Supplier<K, V> supplier) {
        Object key0 = key;
        V v = this.getIfPresent(key0);
        if (v == null) {
            supplier = supplier != null ? supplier : this.supplier;
            return this.putIfAbsent(key0, supplier.get(key0));
        }
        return v;
    }

    @Override
    public V get(Object key) {
        return this.get(key, null);
    }

    public V getIfPresent(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        V v = this.delegate.get(key);
        if (v == null) {
            this.delegate.put(key, value);
            v = value;
        }
        return v;
    }

    @Override
    public V put(K key, V value) {
        return this.delegate.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (Emptys.isNotEmpty(m)) {
            this.delegate.putAll(m);
        }
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    public static <K, V> WrappedNonAbsentMap<K, V> wrap(Map<K, V> map, Supplier<K, V> supplier) {
        return new WrappedNonAbsentMap<K, V>(map, supplier);
    }
}

