/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection;

import com.jn.langx.Ordered;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.comparator.OrderedComparator;
import com.jn.langx.util.function.Supplier;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SortedLinkedHashSet<E>
extends LinkedHashSet<E> {
    private OrderedComparator comparator;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.rwl.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.rwl.writeLock();

    public SortedLinkedHashSet() {
        this(new OrderedComparator());
    }

    public SortedLinkedHashSet(Supplier<E, Integer> defaultOrderSupplier) {
        this(new OrderedComparator<E>(defaultOrderSupplier));
    }

    public SortedLinkedHashSet(OrderedComparator comparator) {
        this.comparator = comparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E o) {
        Preconditions.checkNotNull(o, "Can not add NULL object");
        this.writeLock.lock();
        try {
            boolean present = false;
            present = o instanceof Ordered ? this.addOrderedElement((Ordered)o) : super.add(o);
            boolean bl = present;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        Preconditions.checkNotNull(c, "Can not merge with NULL set");
        this.writeLock.lock();
        try {
            for (E object : c) {
                this.add(object);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean remove(Object o) {
        this.writeLock.lock();
        try {
            boolean bl = super.remove(o);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (Objs.isEmpty(c)) {
            return false;
        }
        this.writeLock.lock();
        try {
            boolean bl = super.removeAll(c);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.readLock.lock();
        try {
            T[] TArray = super.toArray(a);
            return TArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String toString() {
        this.readLock.lock();
        try {
            String string = Strings.join(",", this);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private boolean addOrderedElement(Ordered adding) {
        boolean added = false;
        Object[] tempUnorderedElements = this.toArray();
        if (super.contains(adding)) {
            return false;
        }
        super.clear();
        if (tempUnorderedElements.length == 0) {
            added = super.add(adding);
        } else {
            LinkedHashSet<Object> tempSet = new LinkedHashSet<Object>();
            for (Object current : tempUnorderedElements) {
                if (current instanceof Ordered) {
                    if (this.comparator.compare(adding, current) < 0) {
                        added = super.add(adding);
                        super.add(current);
                        continue;
                    }
                    super.add(current);
                    continue;
                }
                tempSet.add(current);
            }
            if (!added) {
                added = super.add(adding);
            }
            for (Object e : tempSet) {
                super.add(e);
            }
        }
        return added;
    }
}

