/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.NotEmpty;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Function2;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.function.Supplier;
import java.util.List;

public class Preconditions {
    private Preconditions() {
        throw new UnsupportedOperationException();
    }

    public static <T> T test(@NonNull Predicate<T> predicate, @Nullable T argument) {
        return Preconditions.test(predicate, argument, null);
    }

    public static <T> T test(@NonNull Predicate<T> predicate, @Nullable T argument, String message) {
        if (predicate.test(argument)) {
            return argument;
        }
        if (Strings.isNotEmpty(message)) {
            throw new IllegalArgumentException(message);
        }
        throw new IllegalArgumentException(StringTemplates.formatWithPlaceholder("Illegal argument: {}", argument));
    }

    public static <T> T test(@NonNull Predicate<T> predicate, @Nullable T argument, Supplier<Object[], String> messageSupplier, Object ... params) {
        if (predicate.test(argument)) {
            return argument;
        }
        if (Objs.isNull(messageSupplier)) {
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException(messageSupplier.get(params));
    }

    public static <T> T checkNotNull(@NonNull T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    public static <T> T checkNotNullArgument(@NonNull T obj, @NotEmpty String parameter) {
        String errorMessage = parameter;
        if (errorMessage != null) {
            errorMessage = "argument " + errorMessage + " is required";
        }
        return Preconditions.checkNotNull(obj, errorMessage);
    }

    public static <T> T checkNotNull(@NonNull T obj, @Nullable String errorMessage) {
        if (obj == null) {
            if (errorMessage == null) {
                throw new NullPointerException();
            }
            throw new NullPointerException(errorMessage);
        }
        return obj;
    }

    public static <T> T checkNotNull(@NonNull T obj, final @Nullable String errorMessage, Object ... params) {
        return Preconditions.checkNotNull(obj, new Supplier<Object[], String>(){

            @Override
            public String get(Object[] args) {
                return StringTemplates.formatWithPlaceholder(errorMessage, args);
            }
        }, params);
    }

    public static <T> T checkNotNull(@NonNull T obj, @Nullable Supplier<Object[], String> errorMessageSupplier, Object ... params) {
        if (obj == null) {
            if (errorMessageSupplier == null) {
                throw new NullPointerException();
            }
            String errorMessage = errorMessageSupplier.get(params);
            if (errorMessage == null) {
                throw new NullPointerException();
            }
            throw new NullPointerException(errorMessage);
        }
        return obj;
    }

    public static <T> T checkNotEmpty(@Nullable T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    public static <T> T checkNotEmpty(@NonNull T obj, @Nullable String errorMessage) {
        if (Emptys.isEmpty(obj)) {
            if (errorMessage == null) {
                throw new NullPointerException();
            }
            throw new NullPointerException(errorMessage);
        }
        return obj;
    }

    public static <T> T checkNotEmpty(@NonNull T obj, final @Nullable String errorMessage, Object ... params) {
        return Preconditions.checkNotEmpty(obj, new Supplier<Object[], String>(){

            @Override
            public String get(Object[] args) {
                return StringTemplates.formatWithPlaceholder(errorMessage, args);
            }
        }, params);
    }

    public static <T> T checkNotEmpty(@NonNull T obj, @Nullable Supplier<Object[], String> errorMessageSupplier, Object ... params) {
        if (Emptys.isEmpty(obj)) {
            if (Objs.isNull(errorMessageSupplier)) {
                throw new NullPointerException();
            }
            throw new NullPointerException(errorMessageSupplier.get(params));
        }
        return obj;
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression, String errorMessage) {
        if (!expression) {
            throw new IllegalStateException(errorMessage);
        }
    }

    public static void checkState(boolean expression, String errorMessage, Object ... args) {
        if (!expression) {
            throw new IllegalStateException(StringTemplates.formatWithPlaceholder(errorMessage, args));
        }
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, String errorMessage) {
        if (!expression) {
            if (Emptys.isEmpty(errorMessage)) {
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static <T> void checkArgument(boolean expression, final @Nullable String errorMessage, Object ... params) {
        Preconditions.checkArgument(expression, new Supplier<Object[], String>(){

            @Override
            public String get(Object[] args) {
                return StringTemplates.formatWithPlaceholder(errorMessage, args);
            }
        }, params);
    }

    public static void checkArgument(boolean expression, Supplier<Object[], String> errorMessageSupplier, Object ... params) {
        if (!expression) {
            if (Objs.isNull(errorMessageSupplier)) {
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException(errorMessageSupplier.get(params));
        }
    }

    public static void checkTrue(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkTrue(boolean expression, String errorMessage) {
        if (!expression) {
            if (Emptys.isEmpty(errorMessage)) {
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static <T> void checkTrue(boolean expression, final @Nullable String errorMessage, Object ... params) {
        Preconditions.checkTrue(expression, new Supplier<Object[], String>(){

            @Override
            public String get(Object[] args) {
                return StringTemplates.formatWithPlaceholder(errorMessage, args);
            }
        }, params);
    }

    public static void checkTrue(boolean expression, Supplier<Object[], String> errorMessageSupplier, Object ... params) {
        if (!expression) {
            if (Objs.isNull(errorMessageSupplier)) {
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException(errorMessageSupplier.get(params));
        }
    }

    private static RuntimeException outOfBounds(Function2<String, List<Integer>, ? extends RuntimeException> oobef, String checkKind, Integer ... args) {
        List<Integer> largs = Collects.asList(args);
        RuntimeException e = oobef == null ? null : oobef.apply(checkKind, largs);
        return e == null ? new IndexOutOfBoundsException(Preconditions.outOfBoundsMessage(checkKind, largs)) : e;
    }

    private static RuntimeException outOfBoundsCheckIndex(Function2<String, List<Integer>, ? extends RuntimeException> oobe, int index, int length) {
        return Preconditions.outOfBounds(oobe, "checkIndex", index, length);
    }

    private static RuntimeException outOfBoundsCheckFromToIndex(Function2<String, List<Integer>, ? extends RuntimeException> oobe, int fromIndex, int toIndex, int length) {
        return Preconditions.outOfBounds(oobe, "checkFromToIndex", fromIndex, toIndex, length);
    }

    private static RuntimeException outOfBoundsCheckFromIndexSize(Function2<String, List<Integer>, ? extends RuntimeException> oobe, int fromIndex, int size, int length) {
        return Preconditions.outOfBounds(oobe, "checkFromIndexSize", fromIndex, size, length);
    }

    public static <X extends RuntimeException> Function2<String, List<Integer>, X> outOfBoundsExceptionFormatter(final Function<String, X> f) {
        return new Function2<String, List<Integer>, X>(){

            @Override
            public X apply(String checkKind, List<Integer> args) {
                return (RuntimeException)f.apply(Preconditions.outOfBoundsMessage(checkKind, args));
            }
        };
    }

    private static String outOfBoundsMessage(String checkKind, List<Integer> args) {
        if (checkKind == null && args == null) {
            return String.format("Range check failed", new Object[0]);
        }
        if (checkKind == null) {
            return String.format("Range check failed: %s", args);
        }
        if (args == null) {
            return String.format("Range check failed: %s", checkKind);
        }
        int argSize = 0;
        if ("checkIndex".equals(checkKind)) {
            argSize = 2;
        } else if ("checkFromToIndex".equals(checkKind) || "checkFromIndexSize".equals(checkKind)) {
            argSize = 3;
        }
        String string = checkKind = args.size() != argSize ? "" : checkKind;
        if ("checkIndex".equals(checkKind)) {
            return String.format("Index %d out of bounds for length %d", args.get(0), args.get(1));
        }
        if ("checkFromToIndex".equals(checkKind)) {
            return String.format("Range [%d, %d) out of bounds for length %d", args.get(0), args.get(1), args.get(2));
        }
        if ("checkFromIndexSize".equals(checkKind)) {
            return String.format("Range [%d, %<d + %d) out of bounds for length %d", args.get(0), args.get(1), args.get(2));
        }
        return String.format("Range check failed: %s %s", checkKind, args);
    }

    public static <X extends RuntimeException> int checkIndex(int index, int length) {
        if (index < 0 || index >= length) {
            throw new IndexOutOfBoundsException(StringTemplates.formatWithPlaceholder("index {} out of bounds, the length is: {}", index, length));
        }
        return index;
    }

    public static <X extends RuntimeException> int checkIndex(int index, int length, Function2<String, List<Integer>, X> oobef) {
        if (index < 0 || index >= length) {
            throw Preconditions.outOfBoundsCheckIndex(oobef, index, length);
        }
        return index;
    }

    public static <X extends RuntimeException> int checkFromToIndex(int fromIndex, int toIndex, int length, Function2<String, List<Integer>, X> oobef) {
        if (fromIndex < 0 || fromIndex > toIndex || toIndex > length) {
            throw Preconditions.outOfBoundsCheckFromToIndex(oobef, fromIndex, toIndex, length);
        }
        return fromIndex;
    }

    public static <X extends RuntimeException> int checkFromIndexSize(int fromIndex, int size, int length, Function2<String, List<Integer>, X> oobef) {
        if ((length | fromIndex | size) < 0 || size > length - fromIndex) {
            throw Preconditions.outOfBoundsCheckFromIndexSize(oobef, fromIndex, size, length);
        }
        return fromIndex;
    }

    public static int positive(int n, String name) {
        if (n <= 0) {
            throw new IllegalArgumentException(name + " may not be negative or zero");
        }
        return n;
    }

    public static long positive(long n, String argumentName) {
        if (n <= 0L) {
            throw new IllegalArgumentException(argumentName + " may not be negative or zero");
        }
        return n;
    }

    public static int notNegative(int n, String argumentName) {
        if (n < 0) {
            throw new IllegalArgumentException(argumentName + " may not be negative");
        }
        return n;
    }

    public static long notNegative(long n, String argumentName) {
        if (n < 0L) {
            throw new IllegalArgumentException(argumentName + " may not be negative");
        }
        return n;
    }

    public static void checkPositionIndexes(int start, int end, int size) {
        if (start < 0 || end < start || end > size) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndexes(start, end, size));
        }
    }

    private static String badPositionIndexes(int start, int end, int size) {
        if (start < 0 || start > size) {
            return Preconditions.badPositionIndex(start, size, "start index");
        }
        if (end < 0 || end > size) {
            return Preconditions.badPositionIndex(end, size, "end index");
        }
        return StringTemplates.formatWithPlaceholder("end index ({}) must not be less than start index ({})", end, start);
    }

    private static String badPositionIndex(int index, int size, String desc) {
        if (index < 0) {
            return StringTemplates.formatWithPlaceholder("{} ({}) must not be negative", desc, index);
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        return StringTemplates.formatWithPlaceholder("{} ({}) must not be greater than size ({})", desc, index, size);
    }
}

