/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class Numbers {
    private static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);

    public static int parseUnsignedInt(String s) throws NumberFormatException {
        return Numbers.parseUnsignedInt(s, 10);
    }

    public static int parseUnsignedInt(String s, int radix) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int len = s.length();
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar == '-') {
                throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", s));
            }
            if (len <= 5 || radix == 10 && len <= 9) {
                return Integer.parseInt(s, radix);
            }
            long ell = Long.parseLong(s, radix);
            if ((ell & 0xFFFFFFFF00000000L) == 0L) {
                return (int)ell;
            }
            throw new NumberFormatException(String.format("String value %s exceeds range of unsigned int.", s));
        }
        throw new NumberFormatException(s);
    }

    public static Float createFloat(String str) {
        if (str == null) {
            return null;
        }
        return Float.valueOf(Float.parseFloat(str));
    }

    public static Float createFloat(Object d) {
        if (d == null) {
            return null;
        }
        if (d instanceof Number) {
            return Float.valueOf(((Number)d).floatValue());
        }
        if (d instanceof String) {
            return Numbers.createFloat((String)d);
        }
        return null;
    }

    public static Double createDouble(String str) {
        if (str == null) {
            return null;
        }
        return Double.parseDouble(str);
    }

    public static Double createDouble(Object d) {
        if (d == null) {
            return null;
        }
        if (d instanceof Number) {
            return ((Number)d).doubleValue();
        }
        if (d instanceof String) {
            return Numbers.createDouble((String)d);
        }
        return null;
    }

    public static Integer createInteger(String str) {
        if (str == null) {
            return null;
        }
        return Integer.parseInt(str);
    }

    public static Integer createInteger(Object d) {
        if (d == null) {
            return null;
        }
        if (d instanceof Number) {
            return ((Number)d).intValue();
        }
        if (d instanceof String) {
            return Numbers.createInteger((String)d);
        }
        return null;
    }

    public static Short createShort(String str) {
        Integer integer = Numbers.createInteger(str);
        if (integer == null) {
            return null;
        }
        return integer.shortValue();
    }

    public static Byte createByte(String str) {
        Integer integer = Numbers.createInteger(str);
        if (integer == null) {
            return null;
        }
        return integer.byteValue();
    }

    public static Long createLong(String str) {
        if (str == null) {
            return null;
        }
        return Long.parseLong(str);
    }

    public static Long createLong(Object d) {
        if (d == null) {
            return null;
        }
        if (d instanceof Number) {
            return ((Number)d).longValue();
        }
        if (d instanceof String) {
            return Numbers.createLong((String)d);
        }
        return null;
    }

    public static BigInteger createBigInteger(String str) {
        if (str == null) {
            return null;
        }
        return new BigInteger(str);
    }

    public static BigDecimal createBigDecimal(String str) {
        if (str == null) {
            return null;
        }
        if (Strings.isBlank(str)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        return new BigDecimal(str);
    }

    public static BigDecimal toBigDecimal(Number number) {
        if (null == number) {
            return BigDecimal.ZERO;
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Long) {
            return new BigDecimal((Long)number);
        }
        if (number instanceof Integer) {
            return new BigDecimal((Integer)number);
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        return Numbers.createBigDecimal(number.toString());
    }

    public static boolean isZero(Number number) {
        if (number == null) {
            return true;
        }
        if (number instanceof Byte) {
            return number.equals(Byte.valueOf("0"));
        }
        if (number instanceof Short) {
            return number.equals(Short.valueOf("0"));
        }
        if (number instanceof Integer) {
            return number.intValue() == 0;
        }
        if (number instanceof Long) {
            return number.longValue() == 0L;
        }
        if (number instanceof Float) {
            return number.floatValue() == 0.0f;
        }
        if (number instanceof Double) {
            return number.doubleValue() == 0.0;
        }
        if (number instanceof AtomicInteger) {
            return ((AtomicInteger)number).get() == 0;
        }
        if (number instanceof BigInteger) {
            return ((BigInteger)number).intValue() == 0;
        }
        if (number instanceof AtomicLong) {
            return number.longValue() == 0L;
        }
        if (number instanceof BigDecimal) {
            return new BigDecimal(0).equals(number);
        }
        return false;
    }

    private static boolean isAllZeros(String str) {
        if (str == null) {
            return true;
        }
        for (int i = str.length() - 1; i >= 0; --i) {
            if (str.charAt(i) == '0') continue;
            return false;
        }
        return str.length() > 0;
    }

    public static boolean isDigits(String str) {
        if (Strings.isEmpty(str)) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(String str) {
        int i;
        int start;
        if (Strings.isEmpty(str)) {
            return false;
        }
        char[] chars = str.toCharArray();
        int sz = chars.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start = chars[0] == '-' ? 1 : 0;
        if (sz > start + 1 && chars[start] == '0' && chars[start + 1] == 'x') {
            int i2 = start + 2;
            if (i2 == sz) {
                return false;
            }
            while (i2 < chars.length) {
                if (!(chars[i2] >= '0' && chars[i2] <= '9' || chars[i2] >= 'a' && chars[i2] <= 'f' || chars[i2] >= 'A' && chars[i2] <= 'F')) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        --sz;
        for (i = start; i < sz || i < sz + 1 && allowSigns && !foundDigit; ++i) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (chars[i] == '+' || chars[i] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i < chars.length) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                return true;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                return false;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                return foundDigit;
            }
            if (!(allowSigns || chars[i] != 'd' && chars[i] != 'D' && chars[i] != 'f' && chars[i] != 'F')) {
                return foundDigit;
            }
            if (chars[i] == 'l' || chars[i] == 'L') {
                return foundDigit && !hasExp;
            }
            return false;
        }
        return !allowSigns && foundDigit;
    }

    public static Number createNumber(String str) throws NumberFormatException {
        String mant;
        String dec;
        if (str == null) {
            return null;
        }
        if (Strings.isBlank(str)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        if (str.startsWith("--")) {
            return null;
        }
        if (str.startsWith("0x") || str.startsWith("-0x")) {
            return Numbers.createInteger(str);
        }
        char lastChar = str.charAt(str.length() - 1);
        int decPos = str.indexOf(46);
        int expPos = str.indexOf(101) + str.indexOf(69) + 1;
        if (decPos > -1) {
            if (expPos > -1) {
                if (expPos < decPos) {
                    throw new NumberFormatException(str + " is not a valid number.");
                }
                dec = str.substring(decPos + 1, expPos);
            } else {
                dec = str.substring(decPos + 1);
            }
            mant = str.substring(0, decPos);
        } else {
            mant = expPos > -1 ? str.substring(0, expPos) : str;
            dec = null;
        }
        if (!Character.isDigit(lastChar) && lastChar != '.') {
            String exp = expPos > -1 && expPos < str.length() - 1 ? str.substring(expPos + 1, str.length() - 1) : null;
            String numeric2 = str.substring(0, str.length() - 1);
            boolean allZeros = Numbers.isAllZeros(mant) && Numbers.isAllZeros(exp);
            Number number = null;
            switch (lastChar) {
                case 'L': 
                case 'l': {
                    if (dec != null || exp != null || (numeric2.charAt(0) != '-' || !Numbers.isDigits(numeric2.substring(1))) && !Numbers.isDigits(numeric2)) break;
                    try {
                        number = Numbers.createLong(numeric2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        number = Numbers.createBigInteger(numeric2);
                    }
                    break;
                }
                case 'F': 
                case 'f': {
                    try {
                        Float f = Numbers.createFloat(numeric2);
                        if (f.isInfinite() || f.floatValue() == 0.0f && !allZeros) break;
                        number = f;
                    }
                    catch (NumberFormatException f) {}
                    break;
                }
                case 'D': 
                case 'd': {
                    try {
                        Double d = Numbers.createDouble(numeric2);
                        if (!d.isInfinite() && ((double)d.floatValue() != 0.0 || allZeros)) {
                            number = d;
                            break;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    try {
                        number = Numbers.createBigDecimal(numeric2);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
            }
            if (number == null) {
                throw new NumberFormatException(str + " is not a valid number.");
            }
            return number;
        }
        String exp = expPos > -1 && expPos < str.length() - 1 ? str.substring(expPos + 1, str.length()) : null;
        if (dec == null && exp == null) {
            try {
                return Numbers.createInteger(str);
            }
            catch (NumberFormatException numeric2) {
                try {
                    return Numbers.createLong(str);
                }
                catch (NumberFormatException numeric2) {
                    return Numbers.createBigInteger(str);
                }
            }
        }
        boolean allZeros = Numbers.isAllZeros(mant) && Numbers.isAllZeros(exp);
        try {
            Float f = Numbers.createFloat(str);
            if (!f.isInfinite() && (f.floatValue() != 0.0f || allZeros)) {
                return f;
            }
        }
        catch (NumberFormatException f) {
            // empty catch block
        }
        try {
            Double d = Numbers.createDouble(str);
            if (!d.isInfinite() && (d != 0.0 || allZeros)) {
                return d;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Numbers.createBigDecimal(str);
    }

    public static <T extends Number> T parseNumber(String text, Class<T> targetClass) {
        Preconditions.checkNotNull(text, "Text must not be null");
        Preconditions.checkNotNull(targetClass, "Target class must not be null");
        String trimmed = Strings.deleteWhitespace(text);
        if (Byte.class == targetClass) {
            return (T)(Numbers.isHexNumber(trimmed) ? Byte.decode(trimmed) : Numbers.createByte(trimmed));
        }
        if (Short.class == targetClass) {
            return (T)(Numbers.isHexNumber(trimmed) ? Short.decode(trimmed) : Numbers.createShort(trimmed));
        }
        if (Integer.class == targetClass) {
            return (T)(Numbers.isHexNumber(trimmed) ? Integer.decode(trimmed) : Numbers.createInteger(trimmed));
        }
        if (Long.class == targetClass) {
            return (T)(Numbers.isHexNumber(trimmed) ? Long.decode(trimmed) : Numbers.createLong(trimmed));
        }
        if (BigInteger.class == targetClass) {
            return (T)(Numbers.isHexNumber(trimmed) ? Numbers.decodeBigInteger(trimmed) : Numbers.createBigInteger(trimmed));
        }
        if (Float.class == targetClass) {
            return (T)Numbers.createFloat(trimmed);
        }
        if (Double.class == targetClass) {
            return (T)Numbers.createDouble(trimmed);
        }
        if (BigDecimal.class == targetClass || Number.class == targetClass) {
            return (T)Numbers.createBigDecimal(trimmed);
        }
        throw new IllegalArgumentException("Cannot convert String [" + text + "] to target class [" + targetClass.getName() + "]");
    }

    public static <T extends Number> T parseNumber(String text, Class<T> targetClass, @Nullable NumberFormat numberFormat) {
        if (numberFormat != null) {
            Preconditions.checkNotNull(text, "Text must not be null");
            Preconditions.checkNotNull(targetClass, "Target class must not be null");
            DecimalFormat decimalFormat = null;
            boolean resetBigDecimal = false;
            if (numberFormat instanceof DecimalFormat) {
                decimalFormat = (DecimalFormat)numberFormat;
                if (BigDecimal.class == targetClass && !decimalFormat.isParseBigDecimal()) {
                    decimalFormat.setParseBigDecimal(true);
                    resetBigDecimal = true;
                }
            }
            try {
                Number number = numberFormat.parse(Strings.deleteWhitespace(text));
                T t = Numbers.convertNumberToTargetClass(number, targetClass);
                return t;
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("Could not parse number: " + ex.getMessage());
            }
            finally {
                if (resetBigDecimal) {
                    decimalFormat.setParseBigDecimal(false);
                }
            }
        }
        return Numbers.parseNumber(text, targetClass);
    }

    public static <T extends Number> T convertNumberToTargetClass(Number number, Class<T> targetClass) throws IllegalArgumentException {
        Preconditions.checkNotNull(number, "Number must not be null");
        Preconditions.checkNotNull(targetClass, "Target class must not be null");
        if (targetClass.isInstance(number)) {
            return (T)number;
        }
        if (Byte.class == targetClass) {
            long value = Numbers.checkedLongValue(number, targetClass);
            if (value < -128L || value > 127L) {
                Numbers.raiseOverflowException(number, targetClass);
            }
            return (T)Byte.valueOf(number.byteValue());
        }
        if (Short.class == targetClass) {
            long value = Numbers.checkedLongValue(number, targetClass);
            if (value < -32768L || value > 32767L) {
                Numbers.raiseOverflowException(number, targetClass);
            }
            return (T)Short.valueOf(number.shortValue());
        }
        if (Integer.class == targetClass) {
            long value = Numbers.checkedLongValue(number, targetClass);
            if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
                Numbers.raiseOverflowException(number, targetClass);
            }
            return (T)Integer.valueOf(number.intValue());
        }
        if (Long.class == targetClass) {
            long value = Numbers.checkedLongValue(number, targetClass);
            return (T)Long.valueOf(value);
        }
        if (BigInteger.class == targetClass) {
            if (number instanceof BigDecimal) {
                return (T)((BigDecimal)number).toBigInteger();
            }
            return (T)BigInteger.valueOf(number.longValue());
        }
        if (Float.class == targetClass) {
            return (T)Float.valueOf(number.floatValue());
        }
        if (Double.class == targetClass) {
            return (T)Double.valueOf(number.doubleValue());
        }
        if (BigDecimal.class == targetClass) {
            return (T)new BigDecimal(number.toString());
        }
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to unsupported target class [" + targetClass.getName() + "]");
    }

    private static void raiseOverflowException(Number number, Class<?> targetClass) {
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to target class [" + targetClass.getName() + "]: overflow");
    }

    private static long checkedLongValue(Number number, Class<? extends Number> targetClass) {
        BigInteger bigInt = null;
        if (number instanceof BigInteger) {
            bigInt = (BigInteger)number;
        } else if (number instanceof BigDecimal) {
            bigInt = ((BigDecimal)number).toBigInteger();
        }
        if (bigInt != null && (bigInt.compareTo(LONG_MIN) < 0 || bigInt.compareTo(LONG_MAX) > 0)) {
            Numbers.raiseOverflowException(number, targetClass);
        }
        return number.longValue();
    }

    private static boolean isHexNumber(String value) {
        int index = value.startsWith("-") ? 1 : 0;
        return value.startsWith("0x", index) || value.startsWith("0X", index) || value.startsWith("#", index);
    }

    private static BigInteger decodeBigInteger(String value) {
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (value.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (value.startsWith("0x", index) || value.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (value.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (value.startsWith("0", index) && value.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        BigInteger result = new BigInteger(value.substring(index), radix);
        return negative ? result.negate() : result;
    }

    public static int toInt(Number number) {
        return number.intValue();
    }

    public static long toLong(Number number) {
        return number.longValue();
    }

    public static double toDouble(Number number) {
        return number.doubleValue();
    }

    public static float toFloat(Number number) {
        return number.floatValue();
    }

    public static short toShort(Number number) {
        return number.shortValue();
    }

    public static byte toByte(Number number) {
        return number.byteValue();
    }

    public static Number mod(Number left, Number right) {
        if (Numbers.isDouble(left) || Numbers.isDouble(right)) {
            return left.doubleValue() % right.doubleValue();
        }
        return left.longValue() % right.longValue();
    }

    public static Number add(Number left, Number right) {
        if (Numbers.isDouble(left) || Numbers.isDouble(right)) {
            return left.doubleValue() + right.doubleValue();
        }
        return left.longValue() + right.longValue();
    }

    public static Number sub(Number left, Number right) {
        if (Numbers.isDouble(left) || Numbers.isDouble(right)) {
            return left.doubleValue() - right.doubleValue();
        }
        return left.longValue() - right.longValue();
    }

    public static Number mul(Number left, Number right) {
        if (Numbers.isDouble(left) || Numbers.isDouble(right)) {
            return left.doubleValue() * right.doubleValue();
        }
        return left.longValue() * right.longValue();
    }

    public static Number div(Number left, Number right) {
        if (Numbers.isDouble(left) || Numbers.isDouble(right)) {
            return left.doubleValue() / right.doubleValue();
        }
        return left.longValue() / right.longValue();
    }

    public static boolean isInteger(Number number) {
        if (number instanceof Integer) {
            return true;
        }
        return number.longValue() == (long)number.intValue();
    }

    public static boolean isDouble(Number number) {
        if (number instanceof Double) {
            return true;
        }
        return Strings.containsAny((CharSequence)number.toString(), ".");
    }

    public static boolean isLong(Number number) {
        if (number instanceof Long) {
            return true;
        }
        return !Numbers.isDouble(number) && !Numbers.isInteger(number);
    }

    public static int compare(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static int compare(byte x, byte y) {
        return x - y;
    }

    public static int compare(char x, char y) {
        return x - y;
    }

    public static int compare(short x, short y) {
        return x - y;
    }

    public static int compare(float f1, float f2) {
        return Float.compare(f1, f2);
    }

    public static int compare(double d1, double d2) {
        return Double.compare(d1, d2);
    }
}

