/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.grok.logstash;

import com.jn.langx.configuration.AbstractConfigurationLoader;
import com.jn.langx.io.resource.ClassPathResource;
import com.jn.langx.io.resource.FileResource;
import com.jn.langx.io.resource.Resource;
import com.jn.langx.io.resource.Resources;
import com.jn.langx.text.grok.logstash.EcsCompatibility;
import com.jn.langx.text.grok.pattern.PatternDefinition;
import com.jn.langx.text.grok.pattern.PatternDefinitionLoader;
import com.jn.langx.text.grok.pattern.PatternDefinitions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.io.file.filter.IsFileFilter;
import com.jn.langx.util.net.URLs;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class LogStashLocalPatternDefinitionsLoader
extends AbstractConfigurationLoader<PatternDefinition>
implements PatternDefinitionLoader {
    private List<Resource> basedirs = Collects.emptyArrayList();
    private EcsCompatibility ecsCompatibility = EcsCompatibility.disabled;
    private Map<File, Long> lastModifiedMap = new HashMap<File, Long>();
    private Map<String, PatternDefinition> cache = new HashMap<String, PatternDefinition>();

    public EcsCompatibility getEcsCompatibility() {
        return this.ecsCompatibility;
    }

    public void setEcsCompatibility(EcsCompatibility ecsCompatibility) {
        if (ecsCompatibility != null) {
            this.ecsCompatibility = ecsCompatibility;
        }
    }

    @Override
    public Map<String, PatternDefinition> loadAll() {
        List<File> definitionFiles = this.findDefinitionFiles();
        final LinkedHashMap<String, PatternDefinition> map = new LinkedHashMap<String, PatternDefinition>();
        Pipeline.of(definitionFiles).filter(new Predicate<File>(){

            @Override
            public boolean test(File file) {
                return !LogStashLocalPatternDefinitionsLoader.this.lastModifiedMap.containsKey(file) || file.lastModified() > (Long)LogStashLocalPatternDefinitionsLoader.this.lastModifiedMap.get(file);
            }
        }).map(new Function<File, Map<String, PatternDefinition>>(){

            @Override
            public Map<String, PatternDefinition> apply(File file) {
                LogStashLocalPatternDefinitionsLoader.this.lastModifiedMap.put(file, file.lastModified());
                return PatternDefinitions.readDefinitions(file);
            }
        }).forEach(new Consumer<Map<String, PatternDefinition>>(){

            @Override
            public void accept(Map<String, PatternDefinition> m) {
                if (m != null) {
                    map.putAll(m);
                }
            }
        });
        this.cache = map;
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<File> findDefinitionFiles() {
        if (this.basedirs.isEmpty()) {
            List<Resource> list = this.basedirs;
            synchronized (list) {
                if (this.basedirs.isEmpty()) {
                    boolean ecsEnabled;
                    this.basedirs.add(Resources.loadClassPathResource("patterns/legacy", LogStashLocalPatternDefinitionsLoader.class));
                    boolean bl = ecsEnabled = this.ecsCompatibility == EcsCompatibility.v1;
                    if (ecsEnabled) {
                        this.basedirs.add(Resources.loadClassPathResource("patterns/ecs-v1", LogStashLocalPatternDefinitionsLoader.class));
                    }
                }
            }
        }
        final List<File> files = Collects.emptyArrayList();
        Collects.forEach(this.basedirs, new Consumer<Resource>(){

            @Override
            public void accept(Resource resource) {
                File basedir = null;
                if (resource instanceof FileResource) {
                    FileResource fileResource = (FileResource)resource;
                    basedir = fileResource.getRealResource();
                } else if (resource instanceof ClassPathResource) {
                    ClassPathResource classPathResource = (ClassPathResource)resource;
                    URL baseUrl = classPathResource.getRealResource();
                    basedir = URLs.getFile(baseUrl);
                }
                if (basedir != null) {
                    files.addAll(Collects.asList(basedir.listFiles(new IsFileFilter())));
                }
            }
        });
        return files;
    }

    @Override
    public PatternDefinition load(String id) {
        return this.cache.get(id);
    }
}

