/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.grok;

import com.jn.langx.Converter;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Maps;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.converter.BooleanConverter;
import com.jn.langx.util.converter.ByteConverter;
import com.jn.langx.util.converter.DoubleConverter;
import com.jn.langx.util.converter.FloatConverter;
import com.jn.langx.util.converter.IntegerConverter;
import com.jn.langx.util.converter.LongConverter;
import com.jn.langx.util.converter.NoopConverter;
import com.jn.langx.util.converter.ShortConverter;
import com.jn.langx.util.converter.StringToDateConverter;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Functions;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.function.Supplier;
import com.jn.langx.util.function.Supplier0;
import com.jn.langx.util.regexp.Regexp;
import com.jn.langx.util.regexp.Regexps;
import com.jn.langx.util.struct.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Converters {
    private static final Regexp SPLITTER = Regexps.createRegexp("[:;]");
    private static final Map<String, Type> TYPES = Pipeline.of(Type.values()).collect(Collects.toMap(new Supplier0<Map<String, Type>>(){

        @Override
        public Map<String, Type> get() {
            return new HashMap<String, Type>();
        }
    }, new Function<Type, String>(){

        @Override
        public String apply(Type t) {
            return t.name().toLowerCase();
        }
    }, new Function<Type, Type>(){

        @Override
        public Type apply(Type t) {
            return t;
        }
    }));
    private static final Map<String, Type> TYPE_ALIASES = Pipeline.of(Type.values()).map(new Function<Type, Collection<Map.Entry<String, Type>>>(){

        @Override
        public Collection<Map.Entry<String, Type>> apply(final Type type) {
            return Collects.map(type.aliases, new Function<String, Map.Entry<String, Type>>(){

                @Override
                public Map.Entry<String, Type> apply(String alias) {
                    return new Pair<String, Type>(alias, type);
                }
            });
        }
    }).flatMap(new Function<Map.Entry<String, Type>, Map.Entry<String, Type>>(){

        @Override
        public Map.Entry<String, Type> apply(Map.Entry<String, Type> input) {
            return input;
        }
    }).collect(Collects.toMap(new Supplier0<Map<String, Type>>(){

        @Override
        public Map<String, Type> get() {
            return new HashMap<String, Type>();
        }
    }, new Function<Map.Entry<String, Type>, String>(){

        @Override
        public String apply(Map.Entry<String, Type> t) {
            return t.getKey();
        }
    }, new Function<Map.Entry<String, Type>, Type>(){

        @Override
        public Type apply(Map.Entry<String, Type> t) {
            return t.getValue();
        }
    }));

    private static Type getType(String key) {
        Type type = Maps.get(TYPES, key = key.toLowerCase(), new Supplier<String, Type>(){

            @Override
            public Type get(String key) {
                return (Type)((Object)TYPE_ALIASES.get(key));
            }
        });
        if (type == null) {
            throw new IllegalArgumentException("Invalid data type :" + key);
        }
        return type;
    }

    public static Map<String, Converter> getConverters(Collection<String> groupNames, Object ... params) {
        return Pipeline.of(groupNames).filter(new Predicate<String>(){

            @Override
            public boolean test(String groupName) {
                return Converters.containsDelimiter(groupName);
            }
        }).collect(Collects.toHashMap(Functions.noopFunction(), new Function<String, Converter>(){

            @Override
            public Converter apply(String key) {
                String[] list = Converters.splitGrokPattern(key);
                Converter<?, ?> converter = Converters.getType((String)list[1]).converter;
                if (list.length == 3) {
                    // empty if block
                }
                return converter;
            }
        }, true));
    }

    public static Map<String, Type> getGroupTypes(Collection<String> groupNames) {
        return Pipeline.of(groupNames).filter(new Predicate<String>(){

            @Override
            public boolean test(String groupName) {
                return Converters.containsDelimiter(groupName);
            }
        }).map(new Function<String, String[]>(){

            @Override
            public String[] apply(String input) {
                return Converters.splitGrokPattern(input);
            }
        }).collect(Collects.toHashMap(new Function<String[], String>(){

            @Override
            public String apply(String[] input) {
                return input[0];
            }
        }, new Function<String[], Type>(){

            @Override
            public Type apply(String[] input) {
                return Converters.getType(input[1]);
            }
        }, true));
    }

    public static String extractKey(String key) {
        return Converters.splitGrokPattern(key)[0];
    }

    private static boolean containsDelimiter(String string) {
        return string.indexOf(58) >= 0 || string.indexOf(59) >= 0;
    }

    private static String[] splitGrokPattern(String string) {
        return SPLITTER.split(string, 3);
    }

    public static enum Type {
        BYTE(new ByteConverter(), new String[0]),
        BOOLEAN(new BooleanConverter(), new String[0]),
        SHORT(new ShortConverter(), new String[0]),
        INT(new IntegerConverter(), "integer"),
        LONG(new LongConverter(), new String[0]),
        FLOAT(new FloatConverter(), new String[0]),
        DOUBLE(new DoubleConverter(), new String[0]),
        DATETIME(new StringToDateConverter(), "date"),
        STRING(new NoopConverter(), "text");

        public final Converter<?, ?> converter;
        public final List<String> aliases;

        private Type(Converter<?, ?> converter, String ... aliases) {
            this.converter = converter;
            this.aliases = Arrays.asList(aliases);
        }
    }
}

