/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.gm;

import com.jn.langx.annotation.Singleton;
import com.jn.langx.lifecycle.AbstractInitializable;
import com.jn.langx.lifecycle.InitializationException;
import com.jn.langx.registry.GenericRegistry;
import com.jn.langx.security.gm.GmService;
import com.jn.langx.util.Objs;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ServiceLoader;

@Singleton
public class GMs
extends AbstractInitializable {
    private GenericRegistry<GmService> registry = new GenericRegistry(new LinkedHashMap());
    private static GMs INSTANCE;

    private GMs() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GMs getGMs() {
        if (INSTANCE != null) return INSTANCE;
        Class<GMs> clazz = GMs.class;
        synchronized (GMs.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new GMs();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public GmService getDefault() {
        List<GmService> serviceList = this.registry.instances();
        if (Objs.isNotEmpty(serviceList)) {
            return serviceList.get(0);
        }
        return null;
    }

    @Override
    protected void doInit() throws InitializationException {
        for (GmService gmService : ServiceLoader.load(GmService.class)) {
            this.registry.register(gmService);
        }
    }

    public GmService getGmService(String name) {
        return (GmService)this.registry.get(name);
    }
}

