/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.io.stream;

import com.jn.langx.io.stream.WrappedInputStream;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer4;
import com.jn.langx.util.progress.ProgressSource;
import java.io.InputStream;

public class ProgressTracedInputStream
extends WrappedInputStream {
    public ProgressTracedInputStream(InputStream in, final ProgressSource progressSource) {
        super(in, Collects.asList(new Consumer4<InputStream, byte[], Integer, Integer>(){
            Boolean lengthGot = null;

            @Override
            public void accept(InputStream in, byte[] bytes, Integer off, Integer len) {
                if (!progressSource.started()) {
                    progressSource.start();
                }
                progressSource.forward(len.intValue());
                if (progressSource.getExpected() < 0L && this.lengthGot == null) {
                    this.lengthGot = true;
                    try {
                        long expected = progressSource.getProgress() + (long)in.available();
                        progressSource.update(-1L, expected);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }));
    }
}

