/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.io.resource;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.classpath.Classpaths;
import com.jn.langx.io.resource.AbstractLocatableResource;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.ClassLoaders;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.io.file.Filenames;
import com.jn.langx.util.net.URLs;
import com.jn.langx.util.reflect.Reflects;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class ClassPathResource
extends AbstractLocatableResource<URL> {
    public static final String PREFIX = "classpath:";
    @Nullable
    private ClassLoader classLoader;
    @Nullable
    private Class<?> clazz;

    public ClassPathResource(String path) {
        this(path, (ClassLoader)null);
    }

    public ClassPathResource(String path, @Nullable ClassLoader classLoader) {
        Preconditions.checkNotNull(path, "Path must not be null");
        this.classLoader = classLoader != null ? classLoader : ClassLoaders.getDefaultClassLoader();
        String path0 = path;
        if (path.endsWith(".class")) {
            path = Classpaths.classNameToPath(path);
        }
        if (path.startsWith(PREFIX)) {
            path = path.substring(PREFIX.length());
        }
        if (!path.startsWith(PREFIX)) {
            path = path.startsWith("/") ? PREFIX + path.substring(1) : PREFIX + path;
        } else {
            throw new IllegalArgumentException(StringTemplates.formatWithPlaceholder("illegal path {}", path0));
        }
        Preconditions.checkTrue(path.startsWith(PREFIX), "not a classpath resource");
        path = path.substring(PREFIX.length());
        String pathToUse = Filenames.cleanPath(path);
        if (pathToUse.startsWith("/")) {
            pathToUse = pathToUse.substring(1);
        }
        this.setLocation(PREFIX, pathToUse);
    }

    public ClassPathResource(String path, @Nullable Class<?> clazz) {
        Preconditions.checkNotNull(path, "Path must not be null");
        String path0 = path;
        if (clazz == null) {
            this.classLoader = ClassLoaders.getDefaultClassLoader();
        }
        if (path.endsWith(".class")) {
            path = Classpaths.classNameToPath(path);
        }
        if (path.startsWith(PREFIX)) {
            path = path.substring(PREFIX.length());
        }
        if (!path.startsWith(PREFIX)) {
            if (path.startsWith("/")) {
                path = PREFIX + path.substring(1);
            } else if (clazz != null) {
                String packageName = Reflects.getPackageName(clazz);
                path = path.startsWith(packageName = Classpaths.packageToPath(packageName)) ? PREFIX + path : PREFIX + packageName + "/" + path;
            } else {
                path = PREFIX + path;
            }
        } else {
            throw new IllegalArgumentException(StringTemplates.formatWithPlaceholder("illegal path {}", path0));
        }
        Preconditions.checkTrue(path.startsWith(PREFIX), "not a classpath resource");
        path = path.substring(PREFIX.length());
        String pathToUse = Filenames.cleanPath(path);
        if (pathToUse.startsWith("/")) {
            pathToUse = pathToUse.substring(1);
        }
        this.clazz = clazz;
        this.setLocation(PREFIX, pathToUse);
    }

    @Override
    public String getAbsolutePath() {
        URL url = this.getUrlOrNull();
        File file = null;
        if (url != null) {
            try {
                file = new File(url.toURI());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (file != null) {
            return file.getAbsolutePath();
        }
        if (url != null) {
            return url.toString();
        }
        return this.getLocation().getLocation();
    }

    @Override
    public URL getRealResource() {
        try {
            return this.getUrl();
        }
        catch (Throwable ex) {
            return null;
        }
    }

    @Override
    public URL getUrl() throws IOException {
        URL url = this.resolveURL();
        if (url == null) {
            throw new FileNotFoundException(this.toString() + " cannot be resolved to URL because it does not exist");
        }
        return url;
    }

    @Override
    public boolean exists() {
        try {
            this.getUrl();
        }
        catch (FileNotFoundException ex) {
            return false;
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    @Override
    public long contentLength() {
        try {
            return URLs.getContentLength(this.getUrl());
        }
        catch (IOException ex) {
            return -1L;
        }
    }

    public final ClassLoader getClassLoader() {
        return this.clazz != null ? this.clazz.getClassLoader() : this.classLoader;
    }

    protected URL resolveURL() {
        if (this.clazz != null) {
            return this.clazz.getResource("/" + this.getPath());
        }
        if (this.classLoader != null) {
            return this.classLoader.getResource(this.getPath());
        }
        return ClassLoader.getSystemResource(this.getPath());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream is = null;
        if (this.clazz != null) {
            String path = this.getPath();
            if (!path.startsWith("/")) {
                String packageName = Reflects.getPackageName(this.clazz);
                packageName = Classpaths.packageToPath(packageName);
                path = path.replace(packageName + "/", "");
            }
            try {
                is = this.clazz.getResourceAsStream(path);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (is == null) {
                is = this.clazz.getClassLoader().getResourceAsStream(this.getPath());
            }
        } else {
            is = this.classLoader != null ? this.classLoader.getResourceAsStream(this.getPath()) : ClassLoader.getSystemResourceAsStream(this.getPath());
        }
        if (is == null) {
            throw new FileNotFoundException(this.toString() + " cannot be opened because it does not exist");
        }
        return is;
    }

    @Override
    public String toString() {
        return this.getLocation().getLocation();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ClassPathResource o2 = (ClassPathResource)obj;
        return Objs.equals(this.getLocation(), o2.getLocation());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public URL getUrlOrNull() {
        try {
            return this.getUrl();
        }
        catch (IOException e) {
            return null;
        }
    }
}

