/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.exception;

import com.jn.langx.exception.ErrorHandler;
import com.jn.langx.util.logging.Loggers;
import org.slf4j.Logger;

public class ErrorHandlers {
    public static final ErrorHandler IGNORE_ERROR = ErrorHandlers.getIgnoreErrorHandler(Loggers.getLogger(ErrorHandlers.class));

    private ErrorHandlers() {
    }

    public static ErrorHandler getIgnoreErrorHandler() {
        return IGNORE_ERROR;
    }

    public static ErrorHandler getIgnoreErrorHandler(Logger logger) {
        return new IgnoreErrorHandler(logger);
    }

    private static class IgnoreErrorHandler
    implements ErrorHandler {
        private Logger logger;

        private IgnoreErrorHandler(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void handle(Throwable throwable) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error(throwable.getMessage(), throwable);
            }
        }
    }
}

