/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.configuration;

import com.jn.langx.Reloadable;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.configuration.Configuration;
import com.jn.langx.configuration.ConfigurationEventFactory;
import com.jn.langx.configuration.ConfigurationEventType;
import com.jn.langx.configuration.ConfigurationLoader;
import com.jn.langx.configuration.ConfigurationRepository;
import com.jn.langx.configuration.ConfigurationWriter;
import com.jn.langx.event.EventPublisher;
import com.jn.langx.lifecycle.AbstractLifecycle;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.logging.Loggers;
import java.util.Comparator;
import java.util.Map;
import org.slf4j.Logger;

public abstract class BaseConfigurationRepository<T extends Configuration, Loader extends ConfigurationLoader<T>, Writer extends ConfigurationWriter<T>>
extends AbstractLifecycle
implements ConfigurationRepository<T, Loader, Writer>,
Reloadable {
    @NonNull
    protected Loader loader;
    @Nullable
    protected Writer writer;
    @Nullable
    protected EventPublisher eventPublisher;
    @Nullable
    protected ConfigurationEventFactory<T> eventFactory;
    protected Comparator<T> comparator;

    public void setComparator(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    public void setEventFactory(ConfigurationEventFactory<T> eventFactory) {
        this.eventFactory = eventFactory;
    }

    @Override
    public EventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        this.eventPublisher = publisher;
    }

    @Override
    protected void doStop() {
        Logger logger = Loggers.getLogger(this.getClass());
        logger.info("Shutdown configuration repository: {}", (Object)this.getName());
    }

    @Override
    public void setConfigurationLoader(Loader loader) {
        this.loader = loader;
    }

    @Override
    public Loader getConfigurationLoader() {
        return this.loader;
    }

    @Override
    public Writer getConfigurationWriter() {
        return this.writer;
    }

    @Override
    public void setConfigurationWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void removeById(String id) {
        this.removeById(id, true);
    }

    @Override
    public void add(T configuration) {
        this.add(configuration, true);
    }

    @Override
    public void update(T configuration) {
        this.update(configuration, true);
    }

    protected void logMutation(ConfigurationEventType eventType, T configuration) {
        Logger logger = Loggers.getLogger(this.getClass());
        if (logger.isInfoEnabled()) {
            String template = this.eventFactory == null ? " a configuration: {}" : (Strings.startsWithVowelLetter(this.eventFactory.getDomain()) ? " an {} configuration: {}" : " a {} configuration: {}");
            template = Strings.upperCase(eventType.name().toLowerCase(), 0, 1) + template;
            if (this.eventFactory != null) {
                logger.info(template, (Object)this.eventFactory.getDomain(), configuration);
            } else {
                logger.info(template, configuration);
            }
        }
    }

    @Override
    protected void doInit() {
        Preconditions.checkNotNull(this.getName(), "Repository has no named");
        Logger logger = Loggers.getLogger(this.getClass());
        logger.info("Initial configuration repository: {}", (Object)this.getName());
    }

    @Override
    public void reload() {
        Map all;
        final Logger logger = Loggers.getLogger(this.getClass());
        logger.info("Reload repository {}", (Object)this.getName());
        if (this.loader != null && (all = this.loader.loadAll()) != null) {
            Pipeline.of(all.values()).forEach(new Consumer<T>(){

                @Override
                public void accept(T t) {
                    Object old = BaseConfigurationRepository.this.getById(t.getId());
                    if (old != null) {
                        logger.info("reload {}", (Object)t.getId());
                    }
                    BaseConfigurationRepository.this.add(t, false);
                }
            });
        }
    }
}

