/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.commandline.util;

import java.io.File;
import java.util.Map;

public class CommandLineStringUtils {
    public static StringBuilder stringSubstitution(String argStr, Map<? super String, ?> vars, boolean isLenient) {
        StringBuilder argBuf = new StringBuilder();
        if (argStr == null || argStr.length() == 0) {
            return argBuf;
        }
        if (vars == null || vars.size() == 0) {
            return argBuf.append(argStr);
        }
        int argStrLength = argStr.length();
        int cIdx = 0;
        block3: while (cIdx < argStrLength) {
            char ch = argStr.charAt(cIdx);
            int del = 32;
            switch (ch) {
                case '$': {
                    StringBuilder nameBuf = new StringBuilder();
                    del = argStr.charAt(cIdx + 1);
                    if (del == 123) {
                        ++cIdx;
                        ++cIdx;
                        while (cIdx < argStr.length() && ((ch = argStr.charAt(cIdx)) == '_' || ch == '.' || ch == '-' || ch == '+' || Character.isLetterOrDigit(ch))) {
                            nameBuf.append(ch);
                            ++cIdx;
                        }
                        if (nameBuf.length() >= 0) {
                            String value;
                            Object temp = vars.get(nameBuf.toString());
                            if (temp instanceof File) {
                                value = CommandLineStringUtils.fixFileSeparatorChar(((File)temp).getAbsolutePath());
                            } else {
                                String string = value = temp != null ? temp.toString() : null;
                            }
                            if (value != null) {
                                argBuf.append(value);
                            } else if (isLenient) {
                                argBuf.append("${").append(nameBuf.toString()).append("}");
                            } else {
                                throw new RuntimeException("No value found for : " + nameBuf);
                            }
                            del = argStr.charAt(cIdx);
                            if (del != 125) {
                                throw new RuntimeException("Delimiter not found for : " + nameBuf);
                            }
                        }
                        ++cIdx;
                        continue block3;
                    }
                    argBuf.append(ch);
                    ++cIdx;
                    continue block3;
                }
            }
            argBuf.append(ch);
            ++cIdx;
        }
        return argBuf;
    }

    public static String fixFileSeparatorChar(String arg) {
        return arg.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public static String quoteArgument(String argument) {
        String cleanedArgument = argument.trim();
        while (cleanedArgument.startsWith("'") || cleanedArgument.startsWith("\"")) {
            cleanedArgument = cleanedArgument.substring(1);
        }
        while (cleanedArgument.endsWith("'") || cleanedArgument.endsWith("\"")) {
            cleanedArgument = cleanedArgument.substring(0, cleanedArgument.length() - 1);
        }
        StringBuilder buf = new StringBuilder();
        if (cleanedArgument.contains("\"")) {
            if (cleanedArgument.contains("'")) {
                throw new IllegalArgumentException("Can't handle single and double quotes in same argument");
            }
            return buf.append("'").append(cleanedArgument).append("'").toString();
        }
        if (cleanedArgument.contains("'") || cleanedArgument.contains(" ")) {
            return buf.append("\"").append(cleanedArgument).append("\"").toString();
        }
        return cleanedArgument;
    }

    public static boolean isQuoted(String argument) {
        return argument.startsWith("'") && argument.endsWith("'") || argument.startsWith("\"") && argument.endsWith("\"");
    }
}

