/*
 * Decompiled with CFR 0.152.
 */
package com.jn.easyjson.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.jn.easyjson.core.codec.dialect.PropertyCodecConfiguration;
import com.jn.easyjson.jackson.Jacksons;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.Dates;
import com.jn.langx.util.Strings;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateSerializer
extends JsonSerializer {
    public void serialize(Object value, JsonGenerator gen, SerializerProvider ctx) throws IOException {
        if (value == null) {
            gen.writeNull();
            return;
        }
        Date date = null;
        if (value instanceof Date) {
            date = (Date)value;
        } else if (value instanceof Calendar) {
            date = ((Calendar)value).getTime();
        }
        this.serializeDate(date, gen, ctx);
    }

    private void serializeDate(@NonNull Date value, JsonGenerator gen, SerializerProvider ctx) throws IOException {
        PropertyCodecConfiguration propertyCodecConfiguration;
        DateFormat df = null;
        String pattern = null;
        if (Jacksons.getBooleanAttr(ctx, "ENABLE_CUSTOM_CONFIGURATION") && (propertyCodecConfiguration = Jacksons.getPropertyCodecConfiguration(gen)) != null) {
            df = propertyCodecConfiguration.getDateFormat();
            pattern = propertyCodecConfiguration.getDatePattern();
            if (df == null && Strings.isNotBlank((String)pattern)) {
                df = Dates.getSimpleDateFormat((String)pattern);
            }
        }
        if (df == null) {
            df = Jacksons.getDateFormatAttr(ctx, "SERIALIZE_DATE_USING_DATE_FORMAT");
        }
        boolean usingToString = Jacksons.getBooleanAttr(ctx, "SERIALIZE_DATE_USING_TO_STRING");
        if (df == null && Strings.isNotBlank(pattern)) {
            df = Dates.getSimpleDateFormat((String)pattern);
        }
        if (df != null) {
            gen.writeString(df.format(value));
            return;
        }
        if (usingToString) {
            gen.writeString(value.toString());
        }
        gen.writeNumber(value.getTime());
    }
}

