/*
 * Decompiled with CFR 0.152.
 */
package com.jn.easyjson.jackson.modifier;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.jn.easyjson.jackson.DateSeries;
import com.jn.easyjson.jackson.serializer.BooleanSerializer;
import com.jn.easyjson.jackson.serializer.DateSerializer;
import com.jn.easyjson.jackson.serializer.EnumSerializer;
import com.jn.easyjson.jackson.serializer.NumberSerializer;
import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.reflect.type.Types;
import java.lang.reflect.Type;
import java.util.List;

public class EasyjsonBeanSerializerModifier
extends BeanSerializerModifier {
    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        return super.changeProperties(config, beanDesc, beanProperties);
    }

    public JsonSerializer<?> modifyEnumSerializer(SerializationConfig config, JavaType valueType, BeanDescription beanDesc, JsonSerializer<?> serializer) {
        return super.modifyEnumSerializer(config, valueType, beanDesc, serializer);
    }

    public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
        Class beanClass = beanDesc.getBeanClass();
        if (Boolean.class == beanClass || Boolean.TYPE == beanClass) {
            return new BooleanSerializer();
        }
        if ((Reflects.isSubClassOrEquals(Number.class, (Class)beanClass) || Types.isPrimitive((Type)beanClass)) && Number.class.isAssignableFrom(Types.getPrimitiveWrapClass((Type)beanClass))) {
            return new NumberSerializer();
        }
        if (DateSeries.isSupported(beanClass)) {
            return new DateSerializer();
        }
        if (beanClass.isEnum()) {
            return new EnumSerializer();
        }
        return super.modifySerializer(config, beanDesc, serializer);
    }
}

