/*
 * Decompiled with CFR 0.152.
 */
package com.jn.easyjson.jackson.ext;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.cfg.DeserializerFactoryConfig;
import com.fasterxml.jackson.databind.deser.BasicDeserializerFactory;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.type.MapType;
import com.jn.easyjson.core.exclusion.ExclusionConfiguration;
import com.jn.easyjson.jackson.JacksonMigrates;
import com.jn.easyjson.jackson.ext.EasyJsonBeanDeserializerBuilder;
import com.jn.easyjson.jackson.ext.EasyJsonObjectMapper;
import com.jn.langx.util.collection.multivalue.LinkedMultiValueMap;
import com.jn.langx.util.collection.multivalue.MultiValueMap;
import com.jn.langx.util.reflect.Reflects;
import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class EasyJsonBeanDeserializerFactory
extends BeanDeserializerFactory {
    private EasyJsonObjectMapper objectMapper;
    static final HashMap<String, Class<? extends Map>> _mapFallbacks;

    EasyJsonBeanDeserializerFactory(DeserializerFactoryConfig config, EasyJsonObjectMapper objectMapper) {
        super(config);
        this.objectMapper = objectMapper;
        this.configureMapLikeInterfaceDefaultImplementClass();
    }

    public DeserializerFactory withConfig(DeserializerFactoryConfig config) {
        if (this._factoryConfig == config) {
            return this;
        }
        JacksonMigrates.verifyMustOverride(EasyJsonBeanDeserializerFactory.class, (Object)this, "withConfig");
        return new EasyJsonBeanDeserializerFactory(config, this.objectMapper);
    }

    protected List<BeanPropertyDefinition> filterBeanProps(DeserializationContext ctxt, BeanDescription beanDesc, BeanDeserializerBuilder builder, List<BeanPropertyDefinition> propDefsIn, Set<String> ignored) throws JsonMappingException {
        List propertyDefinitions = super.filterBeanProps(ctxt, beanDesc, builder, propDefsIn, ignored);
        if (this.objectMapper != null) {
            Class clazz;
            ExclusionConfiguration exclusionConfiguration = this.objectMapper.getJsonBuilder().getExclusionConfiguration();
            if (!exclusionConfiguration.isExcludedClass(clazz = beanDesc.getType().getRawClass(), false)) {
                Iterator iter = propertyDefinitions.iterator();
                while (iter.hasNext()) {
                    Field field;
                    BeanPropertyDefinition property = (BeanPropertyDefinition)iter.next();
                    if (!property.hasField() || !exclusionConfiguration.isExcludedField(field = property.getField().getAnnotated(), false)) continue;
                    iter.remove();
                }
            } else {
                propertyDefinitions.clear();
            }
        }
        return propertyDefinitions;
    }

    protected MapType _mapAbstractMapType(JavaType type, DeserializationConfig config) {
        Class<? extends Map> mapClass = _mapFallbacks.get(type.getRawClass().getName());
        if (mapClass != null) {
            return (MapType)config.getTypeFactory().constructSpecializedType(type, mapClass);
        }
        return null;
    }

    private void configureMapLikeInterfaceDefaultImplementClass() {
        Field _mapFallbacksField = Reflects.getStaticField(BasicDeserializerFactory.class, (String)"_mapFallbacks");
        HashMap _mapFallbacks = null;
        if (_mapFallbacksField != null) {
            _mapFallbacks = (HashMap)Reflects.getFieldValue((Field)_mapFallbacksField, null, (boolean)true, (boolean)true);
        }
        if (_mapFallbacks != null) {
            _mapFallbacks.put(MultiValueMap.class.getName(), LinkedMultiValueMap.class);
        }
    }

    protected BeanDeserializerBuilder constructBeanDeserializerBuilder(DeserializationContext ctxt, BeanDescription beanDesc) {
        return new EasyJsonBeanDeserializerBuilder(beanDesc, ctxt);
    }

    static {
        HashMap<String, Class<LinkedMultiValueMap>> fallbacks = new HashMap<String, Class<LinkedMultiValueMap>>();
        Class<LinkedHashMap> DEFAULT_MAP = LinkedHashMap.class;
        fallbacks.put(Map.class.getName(), DEFAULT_MAP);
        fallbacks.put(AbstractMap.class.getName(), DEFAULT_MAP);
        fallbacks.put(ConcurrentMap.class.getName(), ConcurrentHashMap.class);
        fallbacks.put(SortedMap.class.getName(), TreeMap.class);
        fallbacks.put(NavigableMap.class.getName(), TreeMap.class);
        fallbacks.put(ConcurrentNavigableMap.class.getName(), ConcurrentSkipListMap.class);
        fallbacks.put(MultiValueMap.class.getName(), LinkedMultiValueMap.class);
        _mapFallbacks = fallbacks;
    }
}

