/*
 * Decompiled with CFR 0.152.
 */
package com.jn.easyjson.jackson.ext;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.fasterxml.jackson.databind.deser.impl.FieldProperty;
import com.fasterxml.jackson.databind.deser.impl.MethodProperty;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdValueProperty;
import com.jn.easyjson.jackson.Jacksons;
import com.jn.easyjson.jackson.deserializer.CustomizedBeanDeserializer;
import com.jn.langx.util.jar.JarVersionMismatchedException;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.reflect.Reflects;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class EasyJsonBeanDeserializerBuilder
extends BeanDeserializerBuilder {
    private static final Logger logger = Loggers.getLogger(EasyJsonBeanDeserializerBuilder.class);
    private DeserializationConfig __config;
    private DeserializationContext __context;
    private static final Field _config_field = Reflects.getDeclaredField(BeanDeserializerBuilder.class, (String)"_config");
    private static final Field _context_field;
    private static final Method _collectAliases_method;
    private static final Method BeanPropertyMap_construct_3args_method;

    public EasyJsonBeanDeserializerBuilder(BeanDescription beanDesc, DeserializationContext ctx) {
        this(EasyJsonBeanDeserializerBuilder.createBeanDeserializerBuilder(beanDesc, ctx));
        this.setDeserializationContext(ctx);
        this.setDeserializationConfig(ctx.getConfig());
    }

    private static BeanDeserializerBuilder createBeanDeserializerBuilder(BeanDescription beanDesc, DeserializationContext ctx) {
        BeanDeserializerBuilder builder = null;
        boolean greatThan_version2_9_0 = Jacksons.getCurrentVersion().compareTo(new Version(2, 9, 0, null)) >= 0;
        builder = greatThan_version2_9_0 ? (BeanDeserializerBuilder)Reflects.newInstance(BeanDeserializerBuilder.class, (Class[])new Class[]{BeanDescription.class, DeserializationContext.class}, (Object[])new Object[]{beanDesc, ctx}) : (BeanDeserializerBuilder)Reflects.newInstance(BeanDeserializerBuilder.class, (Class[])new Class[]{BeanDescription.class, DeserializationConfig.class}, (Object[])new Object[]{beanDesc, ctx.getConfig()});
        if (builder == null) {
            logger.error("please check versions of the jackson libraries: jackson-core, jackson-databind");
            throw new JarVersionMismatchedException("jackson-*");
        }
        return builder;
    }

    public EasyJsonBeanDeserializerBuilder(BeanDeserializerBuilder src) {
        super(src);
    }

    private void setDeserializationConfig(DeserializationConfig config) {
        this.__config = config;
        if (_config_field != null) {
            Reflects.setFieldValue((Field)_config_field, (Object)((Object)this), (Object)this.__config, (boolean)true, (boolean)true);
        }
    }

    private DeserializationConfig getDeserializationConfig() {
        return this.__config;
    }

    private void setDeserializationContext(DeserializationContext context) {
        this.__context = context;
        if (_context_field != null) {
            Reflects.setFieldValue((Field)_context_field, (Object)((Object)this), (Object)this.__context, (boolean)true, (boolean)true);
        }
    }

    private DeserializationContext getDeserializationContext() {
        return this.__context;
    }

    public JsonDeserializer<?> build() {
        boolean anyViews;
        Collection<SettableBeanProperty> props = this._properties.values();
        BeanPropertyMap propertyMap = this.createPropertyMap(props);
        propertyMap.assignIndexes();
        boolean bl = anyViews = !this.getDeserializationConfig().isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION);
        if (!anyViews) {
            for (SettableBeanProperty prop : props) {
                if (!prop.hasViews()) continue;
                anyViews = true;
                break;
            }
        }
        if (this._objectIdReader != null) {
            ObjectIdValueProperty prop = new ObjectIdValueProperty(this._objectIdReader, PropertyMetadata.STD_REQUIRED);
            propertyMap = propertyMap.withProperty((SettableBeanProperty)prop);
        }
        return new CustomizedBeanDeserializer(this, this._beanDesc, propertyMap, this._backRefProperties, this._ignorableProps, this._ignoreAllUnknown, anyViews);
    }

    private BeanPropertyMap createPropertyMap(Collection<SettableBeanProperty> props) {
        boolean caseInsensitive = this.getDeserializationConfig().isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES);
        if (BeanPropertyMap_construct_3args_method != null) {
            return (BeanPropertyMap)Reflects.invoke((Method)BeanPropertyMap_construct_3args_method, null, (Object[])new Object[]{props, caseInsensitive, this.constructBeanPropertyMap(props)}, (boolean)true, (boolean)true);
        }
        return BeanPropertyMap.construct(props, (boolean)this.getDeserializationConfig().isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES));
    }

    protected Map<String, List<PropertyName>> constructBeanPropertyMap(Collection<SettableBeanProperty> props) {
        if (_collectAliases_method != null) {
            return (Map)Reflects.invoke((Method)_collectAliases_method, (Object)((Object)this), (Object[])new Object[]{props}, (boolean)true, (boolean)true);
        }
        return Collections.emptyMap();
    }

    private void reflectInvokeSetAccessible(SettableBeanProperty prop) {
        if (prop instanceof FieldProperty) {
            FieldProperty fieldProperty = (FieldProperty)prop;
            Field field = (Field)fieldProperty.getMember().getAnnotated();
            if (this.__config.canOverrideAccessModifiers()) {
                Jacksons.checkAndFixAccess(field, true);
            }
        } else if (prop instanceof MethodProperty) {
            MethodProperty methodProperty = (MethodProperty)prop;
            Method method = (Method)methodProperty.getMember().getAnnotated();
            if (this.__config.canOverrideAccessModifiers()) {
                Jacksons.checkAndFixAccess(method, true);
            }
        }
    }

    public void addProperty(SettableBeanProperty prop) {
        this.reflectInvokeSetAccessible(prop);
        super.addProperty(prop);
    }

    public void addOrReplaceProperty(SettableBeanProperty prop, boolean allowOverride) {
        if (allowOverride) {
            this.reflectInvokeSetAccessible(prop);
        }
        super.addOrReplaceProperty(prop, allowOverride);
    }

    static {
        if (_config_field != null) {
            _config_field.setAccessible(true);
        }
        if ((_context_field = Reflects.getDeclaredField(BeanDeserializerBuilder.class, (String)"_context")) != null) {
            _context_field.setAccessible(true);
        }
        if ((_collectAliases_method = Reflects.getDeclaredMethod(BeanDeserializerBuilder.class, (String)"_collectAliases", (Class[])new Class[]{Collection.class})) != null) {
            _collectAliases_method.setAccessible(true);
        }
        if ((BeanPropertyMap_construct_3args_method = Reflects.getDeclaredMethod(BeanPropertyMap.class, (String)"construct", (Class[])new Class[]{Collection.class, Boolean.TYPE, Map.class})) != null) {
            BeanPropertyMap_construct_3args_method.setAccessible(true);
        }
    }
}

