/*
 * Decompiled with CFR 0.152.
 */
package com.jn.easyjson.jackson.deserializer;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.jn.easyjson.core.codec.dialect.PropertyCodecConfiguration;
import com.jn.easyjson.jackson.Jacksons;
import com.jn.easyjson.jackson.deserializer.ContextualDeserializer;
import com.jn.langx.util.Strings;
import com.jn.langx.util.Throwables;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.enums.Enums;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.function.Supplier0;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.reflect.Reflects;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Collection;
import org.slf4j.Logger;

public class EnumDeserializer<T extends Enum>
extends JsonDeserializer<T>
implements ContextualDeserializer {
    private static final Logger logger = Loggers.getLogger(EnumDeserializer.class);
    private Class<T> clazz;

    public Class<T> handledType() {
        return this.clazz;
    }

    public EnumDeserializer() {
    }

    public EnumDeserializer(Class clazz) {
        this.clazz = clazz;
    }

    public T deserialize(final JsonParser p, DeserializationContext ctx) throws IOException, JsonProcessingException {
        String string;
        PropertyCodecConfiguration propertyCodecConfiguration;
        Boolean usingIndex = null;
        Boolean usingToString = null;
        String usingField = null;
        if (Jacksons.getBooleanAttr(ctx, "ENABLE_CUSTOM_CONFIGURATION") && (propertyCodecConfiguration = Jacksons.getPropertyCodecConfiguration(p)) != null) {
            usingIndex = propertyCodecConfiguration.getEnumUsingIndex();
            usingToString = propertyCodecConfiguration.getEnumUsingToString();
        }
        final JsonToken jtoken = p.getCurrentToken();
        Class<Object> enumClass = this.clazz;
        if (enumClass == null) {
            Object currentOwner = p.getCurrentValue();
            String currentName = p.getCurrentName();
            if (currentName != null && currentOwner != null) {
                try {
                    Field field = currentOwner.getClass().getDeclaredField(currentName);
                    enumClass = field.getType();
                }
                catch (NoSuchFieldException e) {
                    throw Throwables.wrapAsRuntimeException((Throwable)e);
                }
            }
        }
        if (usingIndex == null) {
            usingIndex = Jacksons.getBooleanAttr(ctx, "SERIALIZE_ENUM_USING_INDEX");
        }
        if (usingIndex.booleanValue() && jtoken == JsonToken.VALUE_NUMBER_INT) {
            int index = p.getIntValue();
            return (T)Enums.ofCode(enumClass, (int)index);
        }
        if (usingToString == null) {
            usingToString = ctx.isEnabled(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        }
        if (usingToString.booleanValue() && jtoken == JsonToken.VALUE_STRING) {
            string = p.getValueAsString();
            if (usingToString.booleanValue()) {
                return (T)Enums.ofToString(enumClass, (String)string);
            }
        }
        if (Strings.isEmpty(usingField)) {
            Collection fields;
            Field field;
            usingField = (String)ctx.getAttribute((Object)"SERIALIZE_ENUM_USING_FIELD");
            if (Strings.isEmpty((String)usingField) && (field = (Field)Pipeline.of((Iterable)(fields = Reflects.getAllDeclaredFields(enumClass, (boolean)false))).findFirst((Predicate)new Predicate<Field>(){

                public boolean test(Field field) {
                    return Reflects.hasAnnotation((AnnotatedElement)field, JsonValue.class);
                }
            })) != null) {
                usingField = field.getName();
            }
            if (Strings.isNotEmpty((String)usingField)) {
                try {
                    Field field2 = enumClass.getDeclaredField(usingField);
                    final Class<?> fieldType = field2.getType();
                    return (T)Enums.ofField(enumClass, (String)usingField, (Supplier0)new Supplier0<Object>(){

                        public Object get() {
                            try {
                                if (String.class == fieldType && jtoken == JsonToken.VALUE_STRING) {
                                    return p.getValueAsString();
                                }
                                if (Character.class == fieldType) {
                                    return Character.valueOf(p.getTextCharacters()[0]);
                                }
                                if (Boolean.class == fieldType) {
                                    return p.getBooleanValue();
                                }
                                if (Number.class == fieldType) {
                                    return p.getNumberValue();
                                }
                            }
                            catch (Throwable ex) {
                                logger.error(ex.getMessage(), ex);
                            }
                            return null;
                        }
                    });
                }
                catch (Throwable ex) {
                    logger.error(ex.getMessage(), ex);
                }
            }
        }
        if (jtoken == JsonToken.VALUE_STRING) {
            string = p.getValueAsString();
            Enum t = Enums.ofName(enumClass, (String)string);
            if (t == null) {
                t = Enums.ofField(enumClass, (String)"name", (Object)string);
            }
            if (t != null) {
                return (T)t;
            }
            t = Enums.ofToString(enumClass, (String)string);
            if (t != null) {
                return (T)t;
            }
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext context, BeanProperty beanProperty, Class<?> type) throws JsonMappingException {
        if (this.handledType() == null || type != null && this.handledType() != type) {
            EnumDeserializer<T> enumDeserializer = new EnumDeserializer<T>();
            enumDeserializer.clazz = type;
            return enumDeserializer;
        }
        return this;
    }
}

