/*
 * Decompiled with CFR 0.152.
 */
package com.jn.easyjson.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.jn.easyjson.core.codec.dialect.PropertyCodecConfiguration;
import com.jn.easyjson.jackson.Jacksons;
import com.jn.langx.util.Dates;
import com.jn.langx.util.Strings;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.reflect.Modifiers;
import com.jn.langx.util.reflect.Reflects;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.TimeZone;
import org.slf4j.Logger;

public class DateDeserializer
extends JsonDeserializer {
    private static Logger logger = Loggers.getLogger(DateDeserializer.class);
    private Class type;

    public DateDeserializer(Class type) {
        this.type = type;
    }

    public Object deserialize(JsonParser p, DeserializationContext ctx) throws IOException, JsonProcessingException {
        java.util.Date date = this.parseDate(p, ctx);
        if (date == null) {
            return null;
        }
        if (this.type == java.util.Date.class) {
            return date;
        }
        if (this.type == Date.class) {
            return new Date(date.getTime());
        }
        if (this.type == Timestamp.class) {
            return new Timestamp(date.getTime());
        }
        if (Reflects.isSubClassOrEquals(Calendar.class, (Class)this.type)) {
            Constructor defaultCtor = Reflects.getConstructor((Class)this.type, (Class[])new Class[0]);
            TimeZone tz = Jacksons.getTimeZone(ctx);
            Calendar c = null;
            if (defaultCtor == null || !Modifiers.isPublic((Member)defaultCtor)) {
                c = Calendar.getInstance(tz);
            } else {
                try {
                    c = (Calendar)defaultCtor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw ctx.instantiationException(this.type, (Throwable)e);
                }
            }
            if (c != null) {
                c.setTimeZone(tz);
                c.setTimeInMillis(date.getTime());
            }
            return c;
        }
        return null;
    }

    private java.util.Date parseDate(JsonParser p, DeserializationContext ctx) throws IOException, JsonProcessingException {
        PropertyCodecConfiguration propertyCodecConfiguration;
        JsonToken curr = p.getCurrentToken();
        if (curr == JsonToken.VALUE_NULL) {
            return null;
        }
        DateFormat df = null;
        String pattern = null;
        if (Jacksons.getBooleanAttr(ctx, "ENABLE_CUSTOM_CONFIGURATION") && (propertyCodecConfiguration = Jacksons.getPropertyCodecConfiguration(p)) != null) {
            df = propertyCodecConfiguration.getDateFormat();
            pattern = propertyCodecConfiguration.getDatePattern();
            if (df == null && Strings.isNotBlank((String)pattern)) {
                df = Dates.getSimpleDateFormat((String)pattern);
            }
        }
        if (df == null) {
            df = Jacksons.getDateFormatAttr(ctx, "SERIALIZE_DATE_USING_DATE_FORMAT");
        }
        boolean usingToString = Jacksons.getBooleanAttr(ctx, "SERIALIZE_DATE_USING_TO_STRING");
        if (curr == JsonToken.VALUE_STRING) {
            if (df == null && Strings.isNotBlank((String)pattern)) {
                df = Dates.getSimpleDateFormat((String)pattern);
            }
            if (df != null) {
                try {
                    return df.parse(p.getValueAsString());
                }
                catch (ParseException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            }
            if (usingToString) {
                return new java.util.Date(p.getValueAsString());
            }
            return ctx.parseDate(p.getValueAsString());
        }
        if (curr.isNumeric()) {
            long timestamp = p.getLongValue();
            return new java.util.Date(timestamp);
        }
        return null;
    }

    public Class<?> handledType() {
        return this.type;
    }
}

