/*
 * Decompiled with CFR 0.152.
 */
package com.jn.easyjson.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.jn.easyjson.core.JSON;
import com.jn.easyjson.core.JSONBuilder;
import com.jn.easyjson.core.JsonHandler;
import com.jn.easyjson.core.annotation.DependOn;
import com.jn.easyjson.core.bean.propertynaming.BeanPropertyNamingPolicy;
import com.jn.easyjson.core.bean.propertynaming.BeanPropertyNamingPolicyRegistry;
import com.jn.easyjson.core.bean.propertynaming.ProxyDialectNamingPolicy;
import com.jn.easyjson.core.exclusion.ExclusionConfiguration;
import com.jn.easyjson.jackson.JacksonAdapter;
import com.jn.easyjson.jackson.Jacksons;
import com.jn.easyjson.jackson.bean.propertynaming.JacksonPropertyNamingStrategy;
import com.jn.easyjson.jackson.deserializer.BooleanDeserializer;
import com.jn.easyjson.jackson.deserializer.Deserializers;
import com.jn.easyjson.jackson.deserializer.EnumDeserializer;
import com.jn.easyjson.jackson.ext.EasyJsonJacksonAnnotationIntrospector;
import com.jn.easyjson.jackson.ext.EasyJsonObjectMapper;
import com.jn.easyjson.jackson.modifier.EasyjsonBeanDeserializerModifier;
import com.jn.easyjson.jackson.modifier.EasyjsonBeanSerializerModifier;
import com.jn.easyjson.jackson.serializer.BooleanSerializer;
import com.jn.easyjson.jackson.serializer.EnumSerializer;
import com.jn.langx.annotation.Name;
import com.jn.langx.util.Strings;
import com.jn.langx.util.reflect.Reflects;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.TimeZone;

@Name(value="jackson")
@DependOn(value="com.fasterxml.jackson.databind.ObjectMapper")
public class JacksonJSONBuilder
extends JSONBuilder {
    private static boolean moduleInited = false;
    private static SimpleModule module = new SimpleModule();

    public JacksonJSONBuilder() {
        this.dialectIdentify(Jacksons.JACKSON);
    }

    public JacksonJSONBuilder(ExclusionConfiguration exclusionConfiguration) {
        super(exclusionConfiguration);
        this.dialectIdentify(Jacksons.JACKSON);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void makesureEasyJsonBaseModuleRegisted() {
        if (moduleInited) return;
        Class<JacksonJSONBuilder> clazz = JacksonJSONBuilder.class;
        synchronized (JacksonJSONBuilder.class) {
            Deserializers simpleDeserializers = new Deserializers();
            module.setDeserializers((SimpleDeserializers)simpleDeserializers);
            module.addSerializer(Boolean.class, (JsonSerializer)new BooleanSerializer());
            module.addDeserializer(Boolean.class, (JsonDeserializer)new BooleanDeserializer());
            module.addDeserializer(Enum.class, new EnumDeserializer());
            module.addSerializer(Enum.class, new EnumSerializer());
            module.setSerializerModifier((BeanSerializerModifier)new EasyjsonBeanSerializerModifier());
            module.setDeserializerModifier((BeanDeserializerModifier)new EasyjsonBeanDeserializerModifier());
            moduleInited = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private void configEnum(EasyJsonObjectMapper objectMapper) {
        SerializationConfig serializationConfig = objectMapper.getSerializationConfig();
        serializationConfig = (SerializationConfig)serializationConfig.withoutAttribute((Object)"SERIALIZE_ENUM_USING_FIELD");
        DeserializationConfig deserializationConfig = objectMapper.getDeserializationConfig();
        deserializationConfig = (DeserializationConfig)deserializationConfig.withoutAttribute((Object)"SERIALIZE_ENUM_USING_INDEX");
        deserializationConfig = (DeserializationConfig)deserializationConfig.withoutAttribute((Object)"SERIALIZE_ENUM_USING_FIELD");
        if (this.serializeEnumUsingIndex()) {
            serializationConfig = serializationConfig.with(SerializationFeature.WRITE_ENUMS_USING_INDEX);
        }
        serializationConfig = (SerializationConfig)serializationConfig.withAttribute((Object)"SERIALIZE_ENUM_USING_INDEX", (Object)this.serializeEnumUsingIndex());
        deserializationConfig = (DeserializationConfig)deserializationConfig.withAttribute((Object)"SERIALIZE_ENUM_USING_INDEX", (Object)this.serializeEnumUsingIndex());
        if (this.serializeEnumUsingToString()) {
            serializationConfig = serializationConfig.with(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
            deserializationConfig = deserializationConfig.with(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        }
        if (this.serializeEnumUsingField() != null) {
            serializationConfig = (SerializationConfig)serializationConfig.withAttribute((Object)"SERIALIZE_ENUM_USING_FIELD", (Object)this.serializeEnumUsingField());
            deserializationConfig = (DeserializationConfig)deserializationConfig.withAttribute((Object)"SERIALIZE_ENUM_USING_FIELD", (Object)this.serializeEnumUsingField());
        }
        objectMapper.setDescrializationConfig(deserializationConfig);
        objectMapper.setSerializationConfig(serializationConfig);
    }

    private void configBoolean(EasyJsonObjectMapper objectMapper) {
        SerializationConfig serializationConfig = objectMapper.getSerializationConfig();
        serializationConfig = (SerializationConfig)serializationConfig.withAttribute((Object)"SERIALIZE_BOOLEAN_USING_1_0", (Object)this.serializeBooleanUsing1_0());
        serializationConfig = (SerializationConfig)serializationConfig.withAttribute((Object)"SERIALIZE_BOOLEAN_USING_ON_OFF", (Object)this.serializeBooleanUsingOnOff());
        DeserializationConfig deserializationConfig = objectMapper.getDeserializationConfig();
        deserializationConfig = (DeserializationConfig)deserializationConfig.withAttribute((Object)"SERIALIZE_BOOLEAN_USING_1_0", (Object)this.serializeBooleanUsing1_0());
        deserializationConfig = (DeserializationConfig)deserializationConfig.withAttribute((Object)"SERIALIZE_BOOLEAN_USING_ON_OFF", (Object)this.serializeBooleanUsingOnOff());
        objectMapper.setSerializationConfig(serializationConfig);
        objectMapper.setDescrializationConfig(deserializationConfig);
    }

    private void configDate(EasyJsonObjectMapper objectMapper) {
        SerializationConfig serializationConfig = objectMapper.getSerializationConfig();
        serializationConfig = (SerializationConfig)serializationConfig.withAttribute((Object)"SERIALIZE_DATE_USING_DATE_FORMAT", (Object)this.serializeUseDateFormat());
        serializationConfig = (SerializationConfig)serializationConfig.withAttribute((Object)"SERIALIZE_DATE_USING_TO_STRING", (Object)this.serializeDateUsingToString());
        serializationConfig = (SerializationConfig)serializationConfig.withAttribute((Object)"SERIALIZE_LOCALE", (Object)this.serializeUsingLocale());
        serializationConfig = (SerializationConfig)serializationConfig.withAttribute((Object)"SERIALIZE_TIMEZONE", (Object)this.serializeUsingTimeZone());
        DeserializationConfig deserializationConfig = objectMapper.getDeserializationConfig();
        deserializationConfig = (DeserializationConfig)deserializationConfig.withAttribute((Object)"SERIALIZE_DATE_USING_DATE_FORMAT", (Object)this.serializeUseDateFormat());
        deserializationConfig = (DeserializationConfig)deserializationConfig.withAttribute((Object)"SERIALIZE_DATE_USING_TO_STRING", (Object)this.serializeDateUsingToString());
        deserializationConfig = (DeserializationConfig)Reflects.invokeAnyMethod((Object)deserializationConfig, (String)"with", (Class[])new Class[]{TimeZone.class}, (Object[])new Object[]{this.serializeUsingTimeZone()}, (boolean)true, (boolean)true);
        deserializationConfig = (DeserializationConfig)Reflects.invokeAnyMethod((Object)deserializationConfig, (String)"with", (Class[])new Class[]{Locale.class}, (Object[])new Object[]{this.serializeUsingLocale()}, (boolean)true, (boolean)true);
        deserializationConfig = (DeserializationConfig)deserializationConfig.withAttribute((Object)"SERIALIZE_LOCALE", (Object)this.serializeUsingLocale());
        deserializationConfig = (DeserializationConfig)deserializationConfig.withAttribute((Object)"SERIALIZE_TIMEZONE", (Object)this.serializeUsingTimeZone());
        objectMapper.setSerializationConfig(serializationConfig);
        objectMapper.setDescrializationConfig(deserializationConfig);
    }

    private void configNumber(EasyJsonObjectMapper objectMapper) {
        SerializationConfig serializationConfig = objectMapper.getSerializationConfig();
        serializationConfig = (SerializationConfig)serializationConfig.withAttribute((Object)"SERIALIZE_LONG_USING_STRING", (Object)this.serializeLongAsString());
        serializationConfig = (SerializationConfig)serializationConfig.withAttribute((Object)"SERIALIZE_NUMBER_USING_STRING", (Object)this.serializeNumberAsString());
        DeserializationConfig deserializationConfig = objectMapper.getDeserializationConfig();
        deserializationConfig = (DeserializationConfig)deserializationConfig.withAttribute((Object)"SERIALIZE_LONG_USING_STRING", (Object)this.serializeLongAsString());
        deserializationConfig = (DeserializationConfig)deserializationConfig.withAttribute((Object)"SERIALIZE_NUMBER_USING_STRING", (Object)this.serializeNumberAsString());
        objectMapper.setSerializationConfig(serializationConfig);
        objectMapper.setDescrializationConfig(deserializationConfig);
    }

    private void configNulls(EasyJsonObjectMapper objectMapper) {
        if (this.serializeNulls()) {
            objectMapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, true);
            SerializationConfig config = objectMapper.getSerializationConfig();
            Method withAppendedAnnotationIntrospector = Reflects.getAnyMethod(SerializationConfig.class, (String)"withAppendedAnnotationIntrospector", (Class[])new Class[]{AnnotationIntrospector.class});
            if (withAppendedAnnotationIntrospector != null) {
                config = (SerializationConfig)Reflects.invoke((Method)withAppendedAnnotationIntrospector, (Object)config, (Object[])new Object[]{new EasyJsonJacksonAnnotationIntrospector()}, (boolean)true, (boolean)true);
            }
            config = (SerializationConfig)config.withAttribute((Object)"SERIALIZE_NULLS", (Object)true);
            objectMapper.setConfig(config);
        } else {
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
    }

    public JSON build() {
        JacksonJSONBuilder.makesureEasyJsonBaseModuleRegisted();
        EasyJsonObjectMapper mapper = new EasyJsonObjectMapper();
        mapper.setJsonBuilder(this);
        mapper.registerModule((Module)module);
        mapper.setSerializationConfig((SerializationConfig)mapper.getSerializationConfig().withAttribute((Object)"ENABLE_CUSTOM_CONFIGURATION", (Object)this.isEnableCustomConfiguration()));
        mapper.setDescrializationConfig((DeserializationConfig)mapper.getDeserializationConfig().withAttribute((Object)"ENABLE_CUSTOM_CONFIGURATION", (Object)this.isEnableCustomConfiguration()));
        this.configNulls(mapper);
        this.configBoolean(mapper);
        this.configNumber(mapper);
        this.configEnum(mapper);
        this.configDate(mapper);
        if (!this.serializeNonFieldGetter()) {
            mapper.configure(MapperFeature.REQUIRE_SETTERS_FOR_GETTERS, true);
        }
        mapper.configure(SerializationFeature.INDENT_OUTPUT, this.prettyFormat());
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(JsonParser.Feature.IGNORE_UNDEFINED, true);
        mapper.enable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS});
        if (Strings.isNotBlank((String)this.beanPropertyNamingPolicy())) {
            BeanPropertyNamingPolicy policy = (BeanPropertyNamingPolicy)BeanPropertyNamingPolicyRegistry.INSTANCE.get((Object)this.beanPropertyNamingPolicy());
            if (this.proxyDialectIdentify() != null) {
                policy = new ProxyDialectNamingPolicy(this.proxyDialectIdentify(), policy);
            }
            mapper.setPropertyNamingStrategy(new JacksonPropertyNamingStrategy(policy));
        }
        JacksonAdapter jsonHandler = new JacksonAdapter();
        jsonHandler.setDelegate((Object)mapper);
        JSON json = new JSON();
        json.setJsonHandler((JsonHandler)jsonHandler);
        jsonHandler.setJsonBuilder(this);
        this.applyCustomizer(json);
        return json;
    }

    protected Object clone() throws CloneNotSupportedException {
        JacksonJSONBuilder result = new JacksonJSONBuilder(this.getExclusionConfiguration());
        this.copyTo(result);
        return result;
    }

    static {
        JacksonJSONBuilder.makesureEasyJsonBaseModuleRegisted();
    }
}

