/*
 * Decompiled with CFR 0.152.
 */
package com.jn.easyjson.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.jn.easyjson.core.JsonException;
import com.jn.easyjson.core.JsonHandlerAdapter;
import com.jn.easyjson.core.JsonTreeNode;
import com.jn.easyjson.jackson.Jacksons;
import com.jn.easyjson.jackson.node.JacksonJsonMapper;
import com.jn.langx.util.collection.multivalue.MultiValueMap;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.io.unicode.Utf8s;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.reflect.type.Types;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import org.slf4j.Logger;

public class JacksonAdapter
extends JsonHandlerAdapter<ObjectMapper> {
    private static final Logger logger = Loggers.getLogger(JacksonAdapter.class);

    public <T> T deserialize(String json, Type typeOfT) throws JsonException {
        try {
            if (this.getJsonBuilder().enableDecodeHex()) {
                json = Utf8s.convertHexToUnicode((String)json);
            }
            return (T)((ObjectMapper)this.getDelegate()).readValue(json, this.toJavaType(typeOfT));
        }
        catch (Throwable ex) {
            throw new JsonException(ex);
        }
    }

    public <T> T deserialize(Reader reader, Type typeOfT) throws JsonException {
        String json = null;
        try {
            json = IOs.readAsString((Reader)reader);
            return this.deserialize(json, typeOfT);
        }
        catch (IOException ex) {
            logger.error("invalid json string: {}", (Object)json);
            throw new JsonException((Throwable)ex);
        }
    }

    private JavaType toJavaType(Type typeOfT) {
        if (Jacksons.isJacksonJavaType(typeOfT)) {
            return Jacksons.toJavaType(typeOfT);
        }
        if (Types.isPrimitive((Type)typeOfT)) {
            return ((ObjectMapper)this.getDelegate()).getTypeFactory().constructType((Type)Types.getPrimitiveWrapClass((Type)typeOfT));
        }
        if (Types.isClass((Type)typeOfT)) {
            return ((ObjectMapper)this.getDelegate()).getTypeFactory().constructType((Type)Types.toClass((Type)typeOfT));
        }
        if (Types.isParameterizedType((Type)typeOfT)) {
            ParameterizedType pType = (ParameterizedType)typeOfT;
            Class parametrized = Types.toClass((Type)pType.getRawType());
            Type[] parameterTypes = pType.getActualTypeArguments();
            JavaType[] parameterClasses = new JavaType[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                parameterClasses[i] = this.toJavaType(parameterTypes[i]);
            }
            if (parametrized.isInterface() && Reflects.isSubClassOrEquals(MultiValueMap.class, (Class)parametrized) && Jacksons.getCurrentVersion().compareTo(Jacksons.VERSION_2_9_0) < 0) {
                CollectionType collectionType = ((ObjectMapper)this.getDelegate()).getTypeFactory().constructCollectionType(Collection.class, parameterClasses[1]);
                return ((ObjectMapper)this.getDelegate()).getTypeFactory().constructMapType(parametrized, parameterClasses[0], (JavaType)collectionType);
            }
            return ((ObjectMapper)this.getDelegate()).getTypeFactory().constructParametricType(parametrized, parameterClasses);
        }
        return Jacksons.toJavaType(typeOfT);
    }

    public JsonTreeNode deserialize(String json) throws JsonException {
        try {
            if (this.getJsonBuilder().enableDecodeHex()) {
                json = Utf8s.convertHexToUnicode((String)json);
            }
            JsonNode jsonNode = ((ObjectMapper)this.getDelegate()).readTree(json);
            return JacksonJsonMapper.toJsonTreeNode(jsonNode);
        }
        catch (Throwable ex) {
            throw new JsonException(ex);
        }
    }

    public String serialize(Object src, Type typeOfT) throws JsonException {
        try {
            if (src instanceof JsonTreeNode) {
                JsonNode jsonNode = JacksonJsonMapper.fromJsonTreeNode((JsonTreeNode)src);
                return ((ObjectMapper)this.getDelegate()).writeValueAsString((Object)jsonNode);
            }
            return ((ObjectMapper)this.getDelegate()).writeValueAsString(src);
        }
        catch (JsonProcessingException e) {
            throw new JsonException((Throwable)e);
        }
    }

    @Deprecated
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.setDelegate(objectMapper);
    }
}

