/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.transport.hostkey.verifier;

import com.jn.agileway.ssh.client.transport.hostkey.HostsKeyRepository;
import com.jn.agileway.ssh.client.transport.hostkey.StrictHostKeyChecking;
import com.jn.agileway.ssh.client.transport.hostkey.codec.PublicKeyCodecs;
import com.jn.agileway.ssh.client.transport.hostkey.knownhosts.HostsKeyEntry;
import com.jn.agileway.ssh.client.transport.hostkey.knownhosts.SimpleHostsKeyEntry;
import com.jn.agileway.ssh.client.transport.hostkey.verifier.HostKeyVerifier;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.logging.Loggers;
import java.io.IOException;
import java.security.PublicKey;
import java.util.List;
import org.slf4j.Logger;

public class KnownHostsVerifier
implements HostKeyVerifier {
    private static final Logger logger = Loggers.getLogger(KnownHostsVerifier.class);
    private StrictHostKeyChecking strictHostKeyChecking;
    private HostsKeyRepository repository;

    public KnownHostsVerifier(HostsKeyRepository repository, StrictHostKeyChecking strictHostKeyChecking) {
        this.repository = repository;
        this.strictHostKeyChecking = strictHostKeyChecking;
    }

    public boolean verify(@NonNull String hostname, int port, @Nullable String serverHostKeyAlgorithm, @NonNull Object publicKey) {
        Preconditions.checkNotNull((Object)hostname);
        Preconditions.checkNotNull((Object)publicKey);
        if (serverHostKeyAlgorithm == null && publicKey instanceof PublicKey) {
            serverHostKeyAlgorithm = PublicKeyCodecs.extractKeyType((PublicKey)publicKey);
        }
        if (Strings.isEmpty((String)serverHostKeyAlgorithm)) {
            return false;
        }
        String adjustedHostname = this.adjustHostname(hostname, port);
        List<HostsKeyEntry> entries = this.repository.find(adjustedHostname, serverHostKeyAlgorithm);
        if (Objs.isNotEmpty(entries)) {
            HostsKeyEntry e = entries.get(0);
            try {
                if (!e.verify(publicKey)) {
                    return this.hostKeyChanged(e, adjustedHostname, publicKey);
                }
                return true;
            }
            catch (IOException ioe) {
                logger.error("Error with {}: {}", (Object)e, (Object)ioe);
                return false;
            }
        }
        return this.unknownHostKey(adjustedHostname, serverHostKeyAlgorithm, publicKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hostKeyChanged(HostsKeyEntry entry, String hostname, Object publicKey) throws IOException {
        Preconditions.checkNotNull((Object)((Object)this.strictHostKeyChecking));
        logger.warn("host key changed: hostname: {}, keyType:{}", (Object)hostname, (Object)entry.getKeyType());
        if (this.strictHostKeyChecking == StrictHostKeyChecking.NO) {
            HostsKeyRepository hostsKeyRepository = this.repository;
            synchronized (hostsKeyRepository) {
                this.repository.remove(hostname, entry.getKeyType());
                SimpleHostsKeyEntry newEntry = new SimpleHostsKeyEntry(hostname, entry.getKeyType(), publicKey);
                if (newEntry.isValid()) {
                    this.repository.add(newEntry);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean unknownHostKey(String hostname, String keyType, Object publicKey) {
        Preconditions.checkNotNull((Object)((Object)this.strictHostKeyChecking));
        logger.info("unknown host key: hostname: {}, keyType:{}", (Object)hostname, (Object)keyType);
        if (this.strictHostKeyChecking == StrictHostKeyChecking.NO) {
            SimpleHostsKeyEntry entry = new SimpleHostsKeyEntry(hostname, keyType, publicKey);
            if (entry.isValid()) {
                HostsKeyRepository hostsKeyRepository = this.repository;
                synchronized (hostsKeyRepository) {
                    this.repository.add(entry);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public List<String> findExistingAlgorithms(String hostname, int port) {
        final String adjustedHostname = this.adjustHostname(hostname, port);
        return Pipeline.of(this.repository.getAll()).filter((Predicate)new Predicate<HostsKeyEntry>(){

            public boolean test(HostsKeyEntry e) {
                return e.applicableTo(adjustedHostname, e.getKeyType());
            }
        }).map((Function)new Function<HostsKeyEntry, String>(){

            public String apply(HostsKeyEntry entry) {
                return entry.getKeyType();
            }
        }).asList();
    }

    private String adjustHostname(String hostname, int port) {
        String lowerHN = hostname.toLowerCase();
        if (port != 22 && port > 0) {
            return "[" + lowerHN + "]:" + port;
        }
        return lowerHN;
    }
}

