/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.sftp.attrs;

import com.jn.agileway.ssh.client.sftp.attrs.FileType;
import com.jn.langx.util.io.file.FilePermission;
import java.util.Collections;
import java.util.Set;

public class FileMode {
    private final int mask;
    private final FileType type;
    private final Set<FilePermission> perms;

    public FileMode(int mask) {
        this.mask = mask;
        this.type = FileType.fromMask(this.getTypeMask());
        this.perms = FilePermission.fromMask((int)this.getPermissionsMask());
    }

    public int getMask() {
        return this.mask;
    }

    public int getTypeMask() {
        return this.mask & 0xF000;
    }

    public int getPermissionsMask() {
        return this.mask & 0xFFF;
    }

    public FileType getType() {
        return this.type;
    }

    public Set<FilePermission> getPermissions() {
        return Collections.unmodifiableSet(this.perms);
    }

    public String toString() {
        return "[mask=" + this.mask + "]";
    }

    public static FileMode createFileMode(FileType fileType, int permissions) {
        return FileMode.createFileMode(fileType, FilePermission.fromMask((int)permissions));
    }

    public static FileMode createFileMode(FileType fileType, Set<FilePermission> permissions) {
        return new FileMode(fileType.getMask() | FilePermission.toMask(permissions));
    }
}

