/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.sftp;

import com.jn.agileway.ssh.client.SshConnection;
import com.jn.agileway.ssh.client.SshConnectionFactory;
import com.jn.agileway.ssh.client.SshConnectionFactoryRegistry;
import com.jn.agileway.ssh.client.sftp.OpenMode;
import com.jn.agileway.ssh.client.sftp.SftpFile;
import com.jn.agileway.ssh.client.sftp.SftpResourceInfo;
import com.jn.agileway.ssh.client.sftp.SftpSession;
import com.jn.agileway.ssh.client.sftp.attrs.FileAttrs;
import com.jn.agileway.ssh.client.sftp.attrs.FileMode;
import com.jn.agileway.ssh.client.sftp.attrs.FileType;
import com.jn.agileway.ssh.client.sftp.exception.NoSuchFileSftpException;
import com.jn.agileway.ssh.client.sftp.exception.SftpException;
import com.jn.agileway.ssh.client.transport.hostkey.StrictHostKeyChecking;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.NotEmpty;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.collection.PrimitiveArrays;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.io.file.Files;
import com.jn.langx.util.io.file.PosixFilePermissions;
import com.jn.langx.util.logging.Loggers;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;

public class Sftps {
    private static final Logger logger = Loggers.getLogger(Sftps.class);
    private static final SshConnectionFactoryRegistry SSH_CONNECTION_FACTORY_REGISTRY = new SshConnectionFactoryRegistry();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileType getFileType(SftpSession session, String filepath) throws SftpException {
        Object file = null;
        try {
            FileAttrs fileAttrs = session.stat(filepath);
            FileType fileType = fileAttrs.getFileMode().getType();
            return fileType;
        }
        catch (NoSuchFileSftpException ex) {
            FileType fileType = FileType.UNKNOWN;
            return fileType;
        }
        finally {
            IOs.close(file);
        }
    }

    public static boolean exists(SftpSession session, String filepath) throws SftpException {
        return Sftps.exists(session, filepath, null);
    }

    public static boolean exists(SftpSession session, String filepath, FileType fileType) throws SftpException {
        FileType type = Sftps.getFileType(session, filepath);
        if (fileType == null) {
            return type != null;
        }
        return type == fileType;
    }

    public static boolean existFile(SftpSession session, String filepath) throws SftpException {
        return Sftps.exists(session, filepath, FileType.REGULAR);
    }

    public static boolean existDirectory(SftpSession session, String directoryPath) throws SftpException {
        return Sftps.exists(session, directoryPath, FileType.DIRECTORY);
    }

    public static void remove(SftpSession session, String path) throws SftpException {
        FileAttrs attrs = session.stat(path);
        if (attrs.isDirectory()) {
            Sftps.removeDir(session, path, false);
        } else {
            session.rm(path);
        }
    }

    public static void removeDir(final SftpSession session, String directory, boolean retainDirectory) throws SftpException {
        List<SftpResourceInfo> children = session.listFiles(directory);
        if (!children.isEmpty()) {
            Collects.forEach(children, (Consumer)new Consumer<SftpResourceInfo>(){

                public void accept(SftpResourceInfo sftpResourceInfo) {
                    try {
                        Sftps.remove(session, sftpResourceInfo.getPath());
                    }
                    catch (Throwable ex) {
                        logger.error(ex.getMessage(), ex);
                    }
                }
            });
        }
        if (!retainDirectory) {
            session.rmdir(directory);
        }
    }

    public static void copy(@NonNull SftpSession session, @NonNull File file, @NotEmpty String remotePath) throws SftpException {
        Preconditions.checkArgument((boolean)file.exists(), (String)"the file {} is not exist", (Object[])new Object[]{file.getPath()});
        if (file.isFile()) {
            if (remotePath.endsWith("/")) {
                Sftps.copyFile(session, file, remotePath, null);
            } else {
                int index = remotePath.lastIndexOf("/");
                String remoteDir = null;
                String filename = null;
                if (index == -1) {
                    remoteDir = "~";
                    filename = remotePath;
                } else {
                    remoteDir = remotePath.substring(0, index);
                    filename = remotePath.substring(index + 1);
                }
                Sftps.copyFile(session, file, remoteDir, filename);
            }
        } else {
            Sftps.copyDir(session, file, remotePath);
        }
    }

    public static int copyFile(@NonNull SftpSession session, @NonNull File file, @NotEmpty String remoteDir, @Nullable String newName) throws SftpException {
        boolean remoteDirExist = Sftps.existDirectory(session, remoteDir);
        if (!remoteDirExist) {
            session.mkdir(remoteDir, null);
        }
        String name = Emptys.isEmpty((Object)newName) ? file.getName() : newName;
        String filepath = remoteDir + "/" + name;
        FileInputStream inputStream = null;
        SftpFile sftpFile = null;
        int sum = 0;
        try {
            sftpFile = session.open(filepath, OpenMode.WRITE, null);
            inputStream = new FileInputStream(file);
            byte[] buffer = new byte[4096];
            int readLength = 0;
            while ((readLength = inputStream.read(buffer, 0, buffer.length)) != -1) {
                sftpFile.write(sum, buffer, 0, readLength);
                sum += readLength;
            }
        }
        catch (Throwable ex) {
            try {
                throw new SftpException(ex);
            }
            catch (Throwable throwable) {
                IOs.close(sftpFile);
                IOs.close(inputStream);
                throw throwable;
            }
        }
        IOs.close((Object)sftpFile);
        IOs.close((Object)inputStream);
        return sum;
    }

    public static void copyDir(final SftpSession session, File localDirectory, final String remoteDir) throws SftpException {
        boolean remoteDirExist = Sftps.existDirectory(session, remoteDir);
        if (!remoteDirExist) {
            session.mkdir(remoteDir, null);
        }
        Collects.forEach((Object[])localDirectory.listFiles(), (Consumer)new Consumer<File>(){

            public void accept(File file) {
                String name = file.getName();
                try {
                    if (file.isFile()) {
                        Sftps.copyFile(session, file, remoteDir, null);
                    } else {
                        Sftps.copyDir(session, file, remoteDir + "/" + name);
                    }
                }
                catch (Throwable ex) {
                    logger.error(ex.getMessage(), ex);
                }
            }
        });
    }

    public static void reverseCopy(SftpSession session, File localDirectory, String path) throws IOException {
        FileType fileType = Sftps.getFileType(session, path);
        if (fileType == FileType.REGULAR) {
            Sftps.reverseCopyFile(session, localDirectory, path);
        } else if (fileType == FileType.DIRECTORY) {
            Sftps.reverseCopyDirectory(session, localDirectory, path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int reverseCopyFile(SftpSession session, File localDirectory, String remoteFile) throws IOException {
        if (!Sftps.existFile(session, remoteFile)) {
            logger.error("remote file is not exist: {}", (Object)remoteFile);
            return -1;
        }
        Files.makeDirs((File)localDirectory);
        FileOutputStream fout = null;
        SftpFile sftpFile = null;
        int sum = 0;
        try {
            fout = new FileOutputStream(localDirectory);
            sftpFile = session.open(remoteFile, OpenMode.READ, null);
            byte[] buffer = new byte[4096];
            int readLength = 0;
            while ((readLength = sftpFile.read(sum, buffer, 0, buffer.length)) != -1) {
                fout.write(buffer, 0, readLength);
                sum += readLength;
            }
        }
        catch (Throwable throwable) {
            IOs.close(sftpFile);
            IOs.close((Object)fout);
            throw throwable;
        }
        IOs.close((Object)sftpFile);
        IOs.close((Object)fout);
        return sum;
    }

    public static void reverseCopyDirectory(final SftpSession session, final File localDirectory, String remoteDirectory) throws IOException {
        if (!Sftps.existDirectory(session, remoteDirectory)) {
            logger.error("remote directory is not exist: {}", (Object)remoteDirectory);
            return;
        }
        Files.makeDirs((File)localDirectory);
        Collects.forEach(session.listFiles(remoteDirectory), (Consumer)new Consumer<SftpResourceInfo>(){

            public void accept(SftpResourceInfo sftpResourceInfo) {
                String name = sftpResourceInfo.getName();
                try {
                    if (sftpResourceInfo.getAttrs().isDirectory()) {
                        Sftps.reverseCopyDirectory(session, new File(localDirectory, name), sftpResourceInfo.getPath());
                    } else {
                        Sftps.reverseCopyFile(session, localDirectory, sftpResourceInfo.getPath());
                    }
                }
                catch (Throwable ex) {
                    logger.error(ex.getMessage(), ex);
                }
            }
        });
    }

    public static void chmod(SftpSession session, String path, int permissions) throws IOException {
        FileAttrs attrs = session.stat(path);
        FileType fileType = attrs.getFileMode().getType();
        FileAttrs attrs2 = new FileAttrs();
        attrs2.setFileMode(FileMode.createFileMode(fileType, permissions));
        session.setStat(path, attrs2);
    }

    public static void chown(SftpSession session, String path, int uid) throws IOException {
        FileAttrs attrs = session.stat(path);
        FileAttrs attrs2 = new FileAttrs();
        attrs2.setUid(uid);
        attrs2.setGid(attrs.getGid());
        session.setStat(path, attrs2);
    }

    public static void chgrp(SftpSession session, String path, int gid) throws IOException {
        FileAttrs attrs = session.stat(path);
        FileAttrs attrs2 = new FileAttrs();
        attrs2.setUid(attrs.getUid());
        attrs2.setGid(gid);
        session.setStat(path, attrs2);
    }

    public static List<String> children(SftpSession session, String directory) throws IOException {
        return Pipeline.of(session.listFiles(directory)).map((Function)new Function<SftpResourceInfo, String>(){

            public String apply(SftpResourceInfo resourceInfo) {
                return resourceInfo.getName();
            }
        }).asList();
    }

    public static PosixFilePermissions getPosixPermission(SftpFile sftpFile) throws IOException {
        FileAttrs attrs = sftpFile.getAttributes();
        int[] groupIds = sftpFile.getSession().getSshConnection().getGroupIds();
        boolean inGroup = Collects.newArrayList((Object[])PrimitiveArrays.wrap((Object)groupIds)).contains(attrs.getGid());
        int uid = sftpFile.getSession().getSshConnection().getUid();
        boolean isOwner = attrs.getUid() == uid;
        return new PosixFilePermissions(attrs.getFileMode().getPermissionsMask(), isOwner, inGroup);
    }

    public static boolean isReadable(SftpFile sftpFile) throws IOException {
        return Sftps.getPosixPermission(sftpFile).isReadable();
    }

    public static boolean isWritable(SftpFile sftpFile) throws IOException {
        return Sftps.getPosixPermission(sftpFile).isWritable();
    }

    public static boolean isExecutable(SftpFile sftpFile) throws IOException {
        return Sftps.getPosixPermission(sftpFile).isExecutable();
    }

    public static void scp(String local, String remote, boolean reverse) throws Throwable {
        String[] segments = Strings.split((String)remote, (String)"@");
        Preconditions.checkArgument((segments.length == 2 ? 1 : 0) != 0, (String)"illegal remote: {}", (Object[])new Object[]{remote});
        String[] userAndPassword = Strings.split((String)segments[0], (String)":");
        Preconditions.checkArgument((userAndPassword.length == 2 ? 1 : 0) != 0, (String)" user, password are required");
        String user = userAndPassword[0];
        String pswd = userAndPassword[1];
        String[] remoteMachinePath = Strings.split((String)segments[1], (String)":");
        Preconditions.checkArgument((remoteMachinePath.length >= 2 ? 1 : 0) != 0, (String)"host, port, remotePath are required");
        String remoteHost = remoteMachinePath[0];
        int remotePort = -1;
        String remotePath = null;
        if (remoteMachinePath.length > 2) {
            remotePort = Integer.parseInt(remoteMachinePath[1]);
            remotePath = remoteMachinePath[2];
        } else {
            remotePath = remoteMachinePath[1];
        }
        Sftps.scp(local, remotePath, remoteHost, remotePort, user, pswd, reverse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scp(@NotEmpty String localPath, @NotEmpty String remotePath, @NotEmpty String remoteHost, int remotePort, @NotEmpty String remoteUser, String remotePswd, boolean reverse) throws IOException, SftpException {
        SftpSession session;
        SshConnection connection;
        block6: {
            Preconditions.checkNotEmpty((Object)localPath, (String)"the local path is required");
            Preconditions.checkNotEmpty((Object)remotePath, (String)"the remote path is required");
            if (remotePort <= 0) {
                remotePort = 22;
            }
            SshConnectionFactory connectionFactory = SSH_CONNECTION_FACTORY_REGISTRY.getDefault();
            Object connectionConfig = connectionFactory.newConfig();
            connectionConfig.setHost(remoteHost);
            connectionConfig.setPort(remotePort);
            connectionConfig.setUser(remoteUser);
            connectionConfig.setPassword(remotePswd);
            connectionConfig.setStrictHostKeyChecking(StrictHostKeyChecking.NO);
            connection = null;
            session = null;
            try {
                connection = connectionFactory.get(connectionConfig);
                session = connection.openSftpSession();
                if (reverse) {
                    File localDir = new File(localPath);
                    if (localDir.exists() && !localDir.isDirectory()) {
                        String error = StringTemplates.formatWithIndex((String)"local path is not a directory: {}", (Object[])new Object[]{localPath});
                        throw new IOException(error);
                    }
                    Sftps.reverseCopy(session, localDir, remotePath);
                    break block6;
                }
                File localFile = new File(localPath);
                if (!localFile.exists()) {
                    logger.error("local path is not exists: {}", (Object)localPath);
                    throw new FileNotFoundException(localPath);
                }
                Sftps.copy(session, localFile, remotePath);
            }
            catch (Throwable throwable) {
                IOs.close(session);
                IOs.close((Object)connection);
                throw throwable;
            }
        }
        IOs.close((Object)session);
        IOs.close((Object)connection);
    }

    static {
        SSH_CONNECTION_FACTORY_REGISTRY.init();
    }
}

