/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.impl.synergy;

import com.jn.agileway.ssh.client.AbstractSshConnection;
import com.jn.agileway.ssh.client.SshConnectionStatus;
import com.jn.agileway.ssh.client.SshException;
import com.jn.agileway.ssh.client.channel.SessionedChannel;
import com.jn.agileway.ssh.client.channel.forwarding.ForwardingClient;
import com.jn.agileway.ssh.client.impl.synergy.SynergyConnectionConfig;
import com.jn.agileway.ssh.client.impl.synergy.SynergyForwardingClient;
import com.jn.agileway.ssh.client.impl.synergy.SynergySessionedChannel;
import com.jn.agileway.ssh.client.impl.synergy.sftp.SynergySftpSession;
import com.jn.agileway.ssh.client.impl.synergy.verifier.ToSynergyHostKeyVerifierAdapter;
import com.jn.agileway.ssh.client.sftp.SftpSession;
import com.sshtools.client.SessionChannelNG;
import com.sshtools.client.SshClient;
import com.sshtools.client.SshClientContext;
import com.sshtools.client.sftp.SftpClient;
import com.sshtools.common.knownhosts.HostKeyVerification;
import com.sshtools.common.publickey.SshKeyUtils;
import com.sshtools.common.ssh.components.SshKeyPair;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;

public class SynergyConnection
extends AbstractSshConnection<SynergyConnectionConfig> {
    private SshClient client;

    @Override
    protected void doClose() throws IOException {
        this.client.close();
    }

    @Override
    public void connect(String host, int port) throws SshException {
        ((SynergyConnectionConfig)this.sshConfig).setHost(host);
        ((SynergyConnectionConfig)this.sshConfig).setPort(port);
    }

    @Override
    public void connect(InetAddress host, int port) throws SshException {
        ((SynergyConnectionConfig)this.sshConfig).setHost(host.getHostName());
        ((SynergyConnectionConfig)this.sshConfig).setPort(port);
    }

    @Override
    public void connect(InetAddress host, int port, InetAddress localAddr, int localPort) throws SshException {
        ((SynergyConnectionConfig)this.sshConfig).setHost(host.getHostName());
        ((SynergyConnectionConfig)this.sshConfig).setPort(port);
        ((SynergyConnectionConfig)this.sshConfig).setLocalHost(localAddr.getHostName());
        ((SynergyConnectionConfig)this.sshConfig).setLocalPort(localPort);
    }

    @Override
    public boolean authenticateWithPassword(String user, String password) throws SshException {
        try {
            SshClientContext context = new SshClientContext();
            context.setHostKeyVerification((HostKeyVerification)new ToSynergyHostKeyVerifierAdapter(this.hostKeyVerifier));
            this.client = new SshClient(((SynergyConnectionConfig)this.sshConfig).getHost(), ((SynergyConnectionConfig)this.sshConfig).getPort(), user, context, 30000L, password.toCharArray(), new SshKeyPair[0]);
            if (this.client.isConnected()) {
                this.setStatus(SshConnectionStatus.CONNECTED);
            }
            return true;
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
    }

    @Override
    public boolean authenticateWithPublicKey(String user, byte[] pemPrivateKey, String passphrase) throws SshException {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(pemPrivateKey);
            SshKeyPair keyPair = SshKeyUtils.getPrivateKey((InputStream)inputStream, (String)passphrase);
            SshClientContext context = new SshClientContext();
            context.setUsername(user);
            context.setHostKeyVerification((HostKeyVerification)new ToSynergyHostKeyVerifierAdapter(this.hostKeyVerifier));
            this.client = new SshClient(((SynergyConnectionConfig)this.sshConfig).getHost(), ((SynergyConnectionConfig)this.sshConfig).getPort(), user, context, new SshKeyPair[]{keyPair});
            if (this.client.isConnected()) {
                this.setStatus(SshConnectionStatus.CONNECTED);
            }
            return true;
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
    }

    @Override
    public SessionedChannel openSession() throws SshException {
        SessionChannelNG channelNG = null;
        try {
            channelNG = this.client.openSessionChannel();
            return new SynergySessionedChannel(channelNG);
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
    }

    @Override
    public ForwardingClient forwardingClient() {
        return new SynergyForwardingClient(this);
    }

    @Override
    public SftpSession openSftpSession() throws SshException {
        try {
            return new SynergySftpSession(new SftpClient(this.client));
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
    }

    SshClient getClient() {
        return this.client;
    }
}

