/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.impl.sshj.sftp;

import com.jn.agileway.ssh.client.sftp.ResponseStatusCode;
import com.jn.agileway.ssh.client.sftp.SftpResourceInfo;
import com.jn.agileway.ssh.client.sftp.attrs.FileAttrs;
import com.jn.agileway.ssh.client.sftp.attrs.FileMode;
import com.jn.agileway.ssh.client.sftp.exception.NoSuchFileSftpException;
import com.jn.agileway.ssh.client.sftp.exception.SftpException;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Objs;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.enums.Enums;
import com.jn.langx.util.function.Consumer;
import java.util.HashSet;
import java.util.Set;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.SFTPException;

class SshjSftps {
    SshjSftps() {
    }

    public static SftpException wrapSftpException(Throwable ex) {
        if (ex instanceof SFTPException) {
            ResponseStatusCode statusCode = (ResponseStatusCode)Enums.ofName(ResponseStatusCode.class, (String)((SFTPException)ex).getStatusCode().name());
            SftpException exception = null;
            exception = statusCode == ResponseStatusCode.NO_SUCH_FILE ? new NoSuchFileSftpException(ex) : new SftpException(ex);
            exception.setStatusCode(statusCode);
            return exception;
        }
        return new SftpException(ex);
    }

    public static Set<OpenMode> toSshjOpenModeSet(int openMode) {
        HashSet openModes = Collects.emptyHashSet();
        if (openMode > 0) {
            if (com.jn.agileway.ssh.client.sftp.OpenMode.isReadable(openMode)) {
                openModes.add(OpenMode.READ);
            }
            if (com.jn.agileway.ssh.client.sftp.OpenMode.isWritable(openMode)) {
                openModes.add(OpenMode.WRITE);
            }
            if (com.jn.agileway.ssh.client.sftp.OpenMode.isCreatable(openMode)) {
                openModes.add(OpenMode.CREAT);
            }
            if (com.jn.agileway.ssh.client.sftp.OpenMode.isAppended(openMode)) {
                openModes.add(OpenMode.APPEND);
            }
            if (com.jn.agileway.ssh.client.sftp.OpenMode.isTruncated(openMode)) {
                openModes.add(OpenMode.TRUNC);
            }
            if (com.jn.agileway.ssh.client.sftp.OpenMode.willFailWhenCreateExist(openMode)) {
                openModes.add(OpenMode.EXCL);
            }
        }
        return openModes;
    }

    public static FileAttributes toFileAttributes(final FileAttrs attrs) {
        FileAttributes attributes = FileAttributes.EMPTY;
        if (attrs != null) {
            Set<String> extendKeys;
            FileMode fileMode;
            final FileAttributes.Builder builder = new FileAttributes.Builder();
            if (attrs.getSize() != null) {
                builder.withSize(attrs.getSize().longValue());
            }
            if ((fileMode = attrs.getFileMode()) != null) {
                builder.withType(FileMode.Type.fromMask((int)fileMode.getType().getMask()));
                builder.withPermissions(fileMode.getPermissionsMask());
            }
            if (attrs.getUid() != null || attrs.getGid() != null) {
                builder.withUIDGID(((Integer)Objs.useValueIfNull((Object)attrs.getUid(), (Object)0)).intValue(), ((Integer)Objs.useValueIfNull((Object)attrs.getGid(), (Object)0)).intValue());
            }
            if (attrs.getAccessTime() != null || attrs.getModifyTime() != null) {
                builder.withAtimeMtime((long)((Integer)Objs.useValueIfNull((Object)attrs.getAccessTime(), (Object)0)).intValue(), (long)((Integer)Objs.useValueIfNull((Object)attrs.getModifyTime(), (Object)0)).intValue());
            }
            if (Emptys.isNotEmpty(extendKeys = attrs.getExtendKeys())) {
                Collects.forEach(extendKeys, (Consumer)new Consumer<String>(){

                    public void accept(String extendKey) {
                        builder.withExtended(extendKey, attrs.getExtend(extendKey));
                    }
                });
            }
            attributes = builder.build();
        }
        return attributes;
    }

    public static FileAttrs fromFileAttributes(FileAttributes attributes) {
        if (attributes == null) {
            return null;
        }
        FileAttrs attrs = new FileAttrs();
        if (attributes.getSize() >= 0L) {
            attrs.setSize(attributes.getSize());
        }
        if (attributes.getAtime() != 0L) {
            attrs.setAccessTime(Long.valueOf(attributes.getAtime()).intValue());
        }
        if (attributes.getMtime() != 0L) {
            attrs.setModifyTime(Long.valueOf(attributes.getMtime()).intValue());
        }
        if ((long)attributes.getUID() != 0L) {
            attrs.setUid(attributes.getUID());
        }
        if ((long)attributes.getGID() != 0L) {
            attrs.setGid(attributes.getGID());
        }
        FileMode fileMode = SshjSftps.fromSshjFileMode(attributes.getMode());
        attrs.setFileMode(fileMode);
        return attrs;
    }

    public static FileMode fromSshjFileMode(net.schmizz.sshj.sftp.FileMode fileMode) {
        if (fileMode == null) {
            return null;
        }
        return new FileMode(fileMode.getMask());
    }

    public static net.schmizz.sshj.sftp.FileMode toSshjFileMode(FileMode fileMode) {
        if (fileMode == null) {
            return null;
        }
        return new net.schmizz.sshj.sftp.FileMode(fileMode.getMask());
    }

    public static SftpResourceInfo fromRemoteResourceInfo(RemoteResourceInfo info) {
        return new SftpResourceInfo(info.getPath(), SshjSftps.fromFileAttributes(info.getAttributes()));
    }
}

