/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.impl.sshj;

import com.jn.agileway.ssh.client.AbstractSshConnection;
import com.jn.agileway.ssh.client.SshConnectionStatus;
import com.jn.agileway.ssh.client.SshException;
import com.jn.agileway.ssh.client.channel.SessionedChannel;
import com.jn.agileway.ssh.client.channel.forwarding.ForwardingClient;
import com.jn.agileway.ssh.client.impl.sshj.SshjConnectionConfig;
import com.jn.agileway.ssh.client.impl.sshj.SshjSessionedChannel;
import com.jn.agileway.ssh.client.impl.sshj.sftp.SshjSftpSession;
import com.jn.agileway.ssh.client.impl.sshj.verifier.ToSshjHostKeyVerifierAdapter;
import com.jn.agileway.ssh.client.sftp.SftpSession;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.net.Nets;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.keyprovider.OpenSSHKeyFile;
import net.schmizz.sshj.userauth.keyprovider.PKCS8KeyFile;
import net.schmizz.sshj.userauth.keyprovider.PuTTYKeyFile;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.PasswordUtils;
import org.slf4j.Logger;

public class SshjConnection
extends AbstractSshConnection<SshjConnectionConfig> {
    private Logger logger = Loggers.getLogger(SshjConnection.class);
    private SSHClient sshClient;

    private void makeSureSshClient() {
        if (this.sshClient == null) {
            this.sshClient = new SSHClient();
        }
    }

    public SSHClient getSshClient() {
        return this.sshClient;
    }

    @Override
    public void connect(String host, int port) throws SshException {
        try {
            this.connect(InetAddress.getByName(host), port);
        }
        catch (UnknownHostException ex) {
            throw new SshException(ex);
        }
    }

    @Override
    public void connect(InetAddress host, int port) throws SshException {
        this.connect(host, port, null, -1);
    }

    @Override
    public void connect(InetAddress host, int port, InetAddress localAddr, int localPort) throws SshException {
        try {
            this.makeSureSshClient();
            if (!this.sshClient.isConnected()) {
                if (!this.hostKeyVerifier.isEmpty()) {
                    this.sshClient.addHostKeyVerifier((HostKeyVerifier)new ToSshjHostKeyVerifierAdapter(this.hostKeyVerifier));
                }
                if (localAddr == null || !Nets.isValidPort((int)localPort)) {
                    this.sshClient.connect(host, port);
                } else {
                    this.sshClient.connect(host, port, localAddr, localPort);
                }
            }
            this.setStatus(SshConnectionStatus.CONNECTED);
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
    }

    @Override
    public boolean authenticateWithPassword(String user, String password) throws SshException {
        Preconditions.checkNotNull((Object)this.sshClient);
        try {
            this.sshClient.authPassword(user, password);
            return true;
        }
        catch (UserAuthException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
    }

    @Override
    public boolean authenticateWithPublicKey(String user, byte[] pemPrivateKey, String passphrase) throws SshException {
        StringReader reader2;
        Preconditions.checkNotNull((Object)this.sshClient);
        String keyContent = new String(pemPrivateKey);
        List keyProviders = Collects.emptyArrayList();
        PasswordFinder passwordFinder = null;
        if (Strings.isNotBlank((String)passphrase)) {
            passwordFinder = PasswordUtils.createOneOff((char[])passphrase.toCharArray());
        }
        try {
            reader2 = new StringReader(keyContent);
            PuTTYKeyFile puTTYKeyFile = new PuTTYKeyFile();
            if (passwordFinder == null) {
                puTTYKeyFile.init((Reader)reader2);
            } else {
                puTTYKeyFile.init((Reader)reader2, passwordFinder);
            }
            puTTYKeyFile.getPrivate();
            keyProviders.add(puTTYKeyFile);
        }
        catch (Throwable reader2) {
            // empty catch block
        }
        try {
            reader2 = new StringReader(keyContent);
            PKCS8KeyFile pkcs8KeyFile = new PKCS8KeyFile();
            if (passwordFinder == null) {
                pkcs8KeyFile.init((Reader)reader2);
            } else {
                pkcs8KeyFile.init((Reader)reader2, passwordFinder);
            }
            pkcs8KeyFile.getPrivate();
            keyProviders.add(pkcs8KeyFile);
        }
        catch (Throwable reader3) {
            // empty catch block
        }
        try {
            reader2 = new StringReader(keyContent);
            OpenSSHKeyFile openSSHKeyFile = new OpenSSHKeyFile();
            if (passwordFinder == null) {
                openSSHKeyFile.init((Reader)reader2);
            } else {
                openSSHKeyFile.init((Reader)reader2, passwordFinder);
            }
            openSSHKeyFile.getPrivate();
            keyProviders.add(openSSHKeyFile);
        }
        catch (Throwable reader4) {
            // empty catch block
        }
        try {
            Preconditions.checkState((!keyProviders.isEmpty() ? 1 : 0) != 0, (String)("the private key is invalid: " + keyContent));
            this.sshClient.authPublickey(user, (Iterable)keyProviders);
        }
        catch (UserAuthException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
        return false;
    }

    @Override
    public SessionedChannel openSession() throws SshException {
        Preconditions.checkState((this.getStatus() == SshConnectionStatus.CONNECTED ? 1 : 0) != 0, (String)"ssh not connected");
        try {
            Session session = this.sshClient.startSession();
            return new SshjSessionedChannel(session);
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
    }

    @Override
    public ForwardingClient forwardingClient() {
        return null;
    }

    @Override
    protected void doClose() throws IOException {
        this.sshClient.close();
    }

    @Override
    public SftpSession openSftpSession() throws SshException {
        try {
            SFTPClient client = this.sshClient.newSFTPClient();
            SshjSftpSession session = new SshjSftpSession(client);
            session.setSshConnection(this);
            return session;
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
    }

    SSHClient getDelegate() {
        return this.sshClient;
    }
}

