/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.impl.jsch.sftp;

import com.jcraft.jsch.SftpATTRS;
import com.jn.agileway.ssh.client.sftp.ResponseStatusCode;
import com.jn.agileway.ssh.client.sftp.attrs.FileAttrs;
import com.jn.agileway.ssh.client.sftp.attrs.FileMode;
import com.jn.agileway.ssh.client.sftp.exception.NoSuchFileSftpException;
import com.jn.agileway.ssh.client.sftp.exception.SftpException;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Objs;
import com.jn.langx.util.enums.Enums;

public class JschSftps {
    public static SftpException wrapSftpException(com.jcraft.jsch.SftpException ex) {
        ResponseStatusCode statusCode = (ResponseStatusCode)Enums.ofCode(ResponseStatusCode.class, (int)ex.id);
        SftpException exception = null;
        exception = statusCode == ResponseStatusCode.NO_SUCH_FILE ? new NoSuchFileSftpException((Throwable)ex) : new SftpException((Throwable)ex);
        exception.setStatusCode(statusCode);
        return exception;
    }

    public static FileAttrs fromSftpATTRS(SftpATTRS sftpATTRS) {
        if (sftpATTRS == null) {
            return null;
        }
        FileAttrs attrs = new FileAttrs();
        attrs.setSize(sftpATTRS.getSize());
        attrs.setUid(sftpATTRS.getUId());
        attrs.setGid(sftpATTRS.getGId());
        attrs.setAccessTime(sftpATTRS.getATime());
        attrs.setModifyTime(sftpATTRS.getMTime());
        FileMode fileMode = new FileMode(sftpATTRS.getPermissions());
        attrs.setFileMode(fileMode);
        return attrs;
    }

    public static SftpATTRS toSftpATTRS(@NonNull SftpATTRS sftpATTRS, @Nullable FileAttrs attrs) {
        FileMode fileMode;
        if (attrs == null) {
            return sftpATTRS;
        }
        Long size = attrs.getSize();
        if (size != null) {
            sftpATTRS.setSIZE(size.longValue());
        }
        Integer uid = attrs.getUid();
        Integer gid = attrs.getGid();
        if (uid != null || gid != null) {
            sftpATTRS.setUIDGID(((Integer)Objs.useValueIfNull((Object)uid, (Object)sftpATTRS.getUId())).intValue(), ((Integer)Objs.useValueIfNull((Object)gid, (Object)sftpATTRS.getGId())).intValue());
        }
        Integer atime = attrs.getAccessTime();
        Integer mtime = attrs.getModifyTime();
        if (atime != null || mtime != null) {
            sftpATTRS.setACMODTIME(((Integer)Objs.useValueIfNull((Object)atime, (Object)sftpATTRS.getATime())).intValue(), ((Integer)Objs.useValueIfNull((Object)mtime, (Object)sftpATTRS.getMTime())).intValue());
        }
        if ((fileMode = attrs.getFileMode()) != null) {
            sftpATTRS.setPERMISSIONS(fileMode.getMask());
        }
        return sftpATTRS;
    }
}

