/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.impl.jsch.knownhosts;

import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.UserInfo;
import com.jn.agileway.ssh.client.transport.hostkey.codec.PublicKeyCodecs;
import com.jn.agileway.ssh.client.transport.hostkey.knownhosts.AbstractHostsKeyEntry;
import com.jn.agileway.ssh.client.transport.hostkey.knownhosts.HashedHostsKeyEntry;
import com.jn.agileway.ssh.client.transport.hostkey.knownhosts.HostsKeyEntry;
import com.jn.agileway.ssh.client.transport.hostkey.knownhosts.OpenSSHKnownHosts;
import com.jn.agileway.ssh.client.transport.hostkey.knownhosts.SimpleHostsKeyEntry;
import com.jn.agileway.ssh.client.utils.Buffer;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Functions;
import com.jn.langx.util.function.Predicate;
import java.util.List;

public class JschKnownHostsKeyRepository
implements HostKeyRepository {
    private OpenSSHKnownHosts knownHosts;
    private static List<String> supportedKeyTypes = Collects.immutableArrayList((Object[])new String[]{"ssh-dss", "ssh-rsa", "ecdsa-sha2-nistp256", "ecdsa-sha2-nistp384", "ecdsa-sha2-nistp521"});

    public JschKnownHostsKeyRepository(OpenSSHKnownHosts knownHosts) {
        this.knownHosts = knownHosts;
    }

    public int check(String host, byte[] key) {
        if (host == null) {
            return 1;
        }
        String keyType = new Buffer.PlainBuffer(key).readString();
        if (!supportedKeyTypes.contains(keyType)) {
            return 1;
        }
        List<HostsKeyEntry> entries = this.knownHosts.find(host, keyType);
        if (Objs.isNotEmpty(entries)) {
            HostsKeyEntry entry = entries.get(0);
            if (entry.verify(key)) {
                return 0;
            }
            return 2;
        }
        return 1;
    }

    public void add(HostKey hostkey, UserInfo ui) {
        String host = hostkey.getHost();
        AbstractHostsKeyEntry entry = null;
        entry = Strings.startsWith((CharSequence)host, (CharSequence)"|1|") ? new HashedHostsKeyEntry(host, hostkey.getType(), hostkey.getKey()) : new SimpleHostsKeyEntry(host, hostkey.getType(), hostkey.getKey());
        if (entry.isValid()) {
            this.knownHosts.add(entry);
        }
    }

    public void remove(String host, String type) {
        this.knownHosts.remove(host, type);
    }

    public void remove(final String host, final String type, final byte[] key) {
        List<HostsKeyEntry> entries = this.knownHosts.find(host, type);
        List found = Pipeline.of(entries).filter((Predicate)new Predicate<HostsKeyEntry>(){

            public boolean test(HostsKeyEntry entry) {
                return Pipeline.of((Object[])new HostsKeyEntry[]{new SimpleHostsKeyEntry(host, type, key), new HashedHostsKeyEntry(host, type, key)}).anyMatch(Functions.equalsPredicate((Object)entry));
            }
        }).asList();
        if (Objs.isNotEmpty((Object)found)) {
            this.knownHosts.remove(host, type);
        }
    }

    public String getKnownHostsRepositoryID() {
        return this.knownHosts.getId();
    }

    public HostKey[] getHostKey() {
        return JschKnownHostsKeyRepository.toJschHostKeys(this.knownHosts.getAll());
    }

    public HostKey[] getHostKey(String host, String type) {
        return JschKnownHostsKeyRepository.toJschHostKeys(this.knownHosts.find(host, type));
    }

    private static HostKey[] toJschHostKeys(List<HostsKeyEntry> entries) {
        return (HostKey[])Pipeline.of(entries).map((Function)new Function<HostsKeyEntry, HostKey>(){

            public HostKey apply(HostsKeyEntry entry) {
                return JschKnownHostsKeyRepository.toJschHostKey(entry);
            }
        }).clearNulls().toArray(HostKey[].class);
    }

    private static HostKey toJschHostKey(HostsKeyEntry entry) {
        if (entry != null && entry.isValid()) {
            try {
                return new HostKey(entry.getMarker().getName(), entry.getHosts(), 0, PublicKeyCodecs.toPublicKeyBytes(entry.getPublicKey()), null);
            }
            catch (Throwable ex) {
                return null;
            }
        }
        return null;
    }
}

