/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.impl.jsch;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.ChannelSubsystem;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jn.agileway.ssh.client.SshException;
import com.jn.agileway.ssh.client.channel.AbstarctSessionedChannel;
import com.jn.agileway.ssh.client.impl.jsch.JschChannelType;
import com.jn.agileway.ssh.client.utils.PTYMode;
import com.jn.agileway.ssh.client.utils.Signal;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.io.IOs;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;

class JschSessionedChannel
extends AbstarctSessionedChannel {
    private Session session;
    private Channel channel;
    private JschChannelType type = JschChannelType.SESSION;
    private boolean agentForwarding = false;
    private boolean x11Forwarding = false;
    private Hashtable<String, String> envVariables = Collects.emptyHashtable();
    private String term = "vt100";
    private int termWidthCharacters = 80;
    private int termHeightCharacters = 24;
    private int termWidthPixels = 640;
    private int termHeightPixels = 480;
    private Map<PTYMode, Integer> terminalModes = null;
    private InputStream inputStream;
    private InputStream errorInputStream;
    private OutputStream outputStream;

    JschSessionedChannel(Session session) {
        Preconditions.checkNotNull((Object)session);
        this.session = session;
    }

    @Override
    public void pty(String term) throws SshException {
        this.pty(term, 0, 0, 0, 0, null);
    }

    @Override
    public void pty(String term, int termWidthCharacters, int termHeightCharacters, int termWidthPixels, int termHeightPixels, Map<PTYMode, Integer> terminalModes) throws SshException {
        this.term = term;
        this.termWidthCharacters = termWidthCharacters;
        this.termHeightCharacters = termHeightCharacters;
        this.termWidthPixels = termWidthPixels;
        this.termHeightPixels = termHeightPixels;
        this.terminalModes = terminalModes;
    }

    @Override
    protected void internalX11Forwarding(String host, int port, boolean singleConnection, String x11AuthenticationProtocol, String x11AuthenticationCookie, int x11ScreenNumber) throws SshException {
        this.x11Forwarding = true;
        this.session.setX11Host(host);
        this.session.setX11Port(port);
        this.session.setX11Cookie(x11AuthenticationCookie);
    }

    @Override
    protected void internalExec(String command) throws SshException {
        Preconditions.checkNotEmpty((Object)command, (String)"the command is illegal : {}", (Object[])new Object[]{command});
        Preconditions.checkState((this.session != null && this.session.isConnected() ? 1 : 0) != 0, (String)"the session is not connected");
        this.type = JschChannelType.EXEC;
        try {
            ChannelExec channel = (ChannelExec)this.session.openChannel(this.type.getName());
            channel.setCommand(command);
            this.channel = channel;
            this.startChannel();
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
    }

    @Override
    protected void internalSubsystem(String subsystem) throws SshException {
        Preconditions.checkNotEmpty((Object)subsystem, (String)"the subsystem is illegal : {}", (Object[])new Object[]{subsystem});
        Preconditions.checkState((this.session != null && this.session.isConnected() ? 1 : 0) != 0, (String)"the session is not connected");
        try {
            this.type = JschChannelType.SUBSYSTEM;
            ChannelSubsystem channel = (ChannelSubsystem)this.session.openChannel(this.type.getName());
            channel.setSubsystem(subsystem);
            this.channel = channel;
            this.startChannel();
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
    }

    @Override
    protected void internalShell() throws SshException {
        Preconditions.checkState((this.session != null && this.session.isConnected() ? 1 : 0) != 0, (String)"the session is not connected");
        try {
            this.type = JschChannelType.SHELL;
            this.channel = this.session.openChannel(this.type.getName());
            this.startChannel();
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
    }

    private void startChannel() throws JSchException {
        this.prepareConnect();
        this.channel.connect();
        this.outputStream = this.getOutputStream();
        this.inputStream = this.getInputStream();
        this.errorInputStream = this.getErrorInputStream();
    }

    private void prepareConnect() {
        switch (this.type) {
            case SUBSYSTEM: {
                ((ChannelSubsystem)this.channel).setAgentForwarding(this.agentForwarding);
                break;
            }
            case EXEC: {
                ((ChannelExec)this.channel).setAgentForwarding(this.agentForwarding);
                break;
            }
            case SHELL: {
                ((ChannelShell)this.channel).setAgentForwarding(this.agentForwarding);
                break;
            }
        }
        this.channel.setXForwarding(this.x11Forwarding);
        byte[] terminalModesBytes = null;
        if (Emptys.isNotEmpty(this.terminalModes)) {
            terminalModesBytes = PTYMode.encode(this.terminalModes);
        }
        switch (this.type) {
            case SUBSYSTEM: {
                ChannelSubsystem subsystem = (ChannelSubsystem)this.channel;
                subsystem.setPtyType(this.term, this.termWidthCharacters, this.termHeightCharacters, this.termWidthPixels, this.termHeightPixels);
                subsystem.setTerminalMode(terminalModesBytes);
                break;
            }
            case EXEC: {
                ChannelExec exec = (ChannelExec)this.channel;
                exec.setPtyType(this.term, this.termWidthCharacters, this.termHeightCharacters, this.termWidthPixels, this.termHeightPixels);
                exec.setTerminalMode(terminalModesBytes);
                break;
            }
            case SHELL: {
                ChannelShell shell = (ChannelShell)this.channel;
                shell.setPtyType(this.term, this.termWidthCharacters, this.termHeightCharacters, this.termWidthPixels, this.termHeightPixels);
                shell.setTerminalMode(terminalModesBytes);
                break;
            }
        }
        if (!this.envVariables.isEmpty()) {
            switch (this.type) {
                case SUBSYSTEM: {
                    Collects.forEach(this.envVariables, (Consumer2)new Consumer2<String, String>(){

                        public void accept(String variable, String value) {
                            ((ChannelSubsystem)JschSessionedChannel.this.channel).setEnv(variable, value);
                        }
                    });
                    break;
                }
                case EXEC: {
                    Collects.forEach(this.envVariables, (Consumer2)new Consumer2<String, String>(){

                        public void accept(String variable, String value) {
                            ((ChannelExec)JschSessionedChannel.this.channel).setEnv(variable, value);
                        }
                    });
                    break;
                }
                case SHELL: {
                    Collects.forEach(this.envVariables, (Consumer2)new Consumer2<String, String>(){

                        public void accept(String variable, String value) {
                            ((ChannelShell)JschSessionedChannel.this.channel).setEnv(variable, value);
                        }
                    });
                    break;
                }
            }
        }
    }

    @Override
    public void env(String variableName, String variableValue) throws SshException {
        this.envVariables.put(variableName, variableValue);
    }

    @Override
    public void signal(Signal signal) throws SshException {
        Preconditions.checkState((this.channel != null && this.channel.isConnected() ? 1 : 0) != 0);
        Preconditions.checkNotEmpty((Object)((Object)signal), (String)"the signal is null or empty");
        Preconditions.checkArgument((signal != Signal.UNKNOWN ? 1 : 0) != 0, (String)"the signal is UNKNOWN");
        try {
            this.channel.sendSignal(signal.name());
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
    }

    @Override
    public int getExitStatus() {
        int exitStatus = this.channel.getExitStatus();
        long maxWait = 5000L;
        while (exitStatus == -1) {
            try {
                int timeout = 10;
                maxWait -= (long)timeout;
                this.wait(timeout);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            exitStatus = this.channel.getExitStatus();
        }
        return exitStatus;
    }

    @Override
    public String getType() {
        return this.type.getName();
    }

    @Override
    public void close() {
        IOs.close((Object)this.outputStream);
        this.outputStream = null;
        IOs.close((Object)this.errorInputStream);
        this.errorInputStream = null;
        IOs.close((Object)this.inputStream);
        this.inputStream = null;
        this.session = null;
        if (this.channel != null) {
            this.channel.disconnect();
        }
    }

    @Override
    public InputStream getInputStream() throws SshException {
        if (this.inputStream == null) {
            try {
                this.inputStream = this.channel.getInputStream();
            }
            catch (Throwable ex) {
                throw new SshException(ex);
            }
        }
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() throws SshException {
        if (this.outputStream == null) {
            try {
                this.outputStream = this.channel.getOutputStream();
            }
            catch (Throwable ex) {
                throw new SshException(ex);
            }
        }
        return this.outputStream;
    }

    @Override
    public InputStream getErrorInputStream() throws SshException {
        Preconditions.checkState((this.channel != null ? 1 : 0) != 0);
        if (this.errorInputStream == null) {
            try {
                InputStream errorInputStream = null;
                switch (this.type) {
                    case EXEC: {
                        errorInputStream = ((ChannelExec)this.channel).getErrStream();
                        break;
                    }
                    case SUBSYSTEM: {
                        errorInputStream = ((ChannelSubsystem)this.channel).getErrStream();
                        break;
                    }
                    case SHELL: {
                        break;
                    }
                }
                this.errorInputStream = errorInputStream;
            }
            catch (Throwable ex) {
                throw new SshException(ex);
            }
        }
        return this.errorInputStream;
    }
}

