/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.impl.jsch;

import com.jcraft.jsch.Logger;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.logging.Level;
import com.jn.langx.util.logging.Loggers;

public class JschLoggerToSlf4jLogger
implements Logger {
    private org.slf4j.Logger delegate = Loggers.getLogger(JschLoggerToSlf4jLogger.class);

    public boolean isEnabled(int level) {
        return JschLoggerToSlf4jLogger.isEnabled(this.delegate, this.toLogLevel(level));
    }

    public void log(int level, String message) {
        Loggers.log((org.slf4j.Logger)this.delegate, (Level)this.toLogLevel(level), null, (String)message, (Object[])new Object[0]);
    }

    private Level toLogLevel(int level) {
        if (level <= 0) {
            return Level.DEBUG;
        }
        if (level == 1) {
            return Level.INFO;
        }
        if (level == 2) {
            return Level.WARN;
        }
        return Level.ERROR;
    }

    private static boolean isEnabled(@NonNull org.slf4j.Logger logger, @NonNull Level level) {
        Preconditions.checkNotNull((Object)level);
        Preconditions.checkNotNull((Object)logger);
        boolean enabled = false;
        switch (level) {
            case TRACE: {
                enabled = logger.isTraceEnabled();
                break;
            }
            case DEBUG: {
                enabled = logger.isDebugEnabled();
                break;
            }
            case INFO: {
                enabled = logger.isInfoEnabled();
                break;
            }
            case WARN: {
                enabled = logger.isWarnEnabled();
                break;
            }
            default: {
                enabled = logger.isErrorEnabled();
            }
        }
        return enabled;
    }
}

