/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.impl.ganymedssh2.verifier;

import ch.ethz.ssh2.ServerHostKeyVerifier;
import com.jn.agileway.ssh.client.impl.ganymedssh2.verifier.KnownHosts;
import com.jn.agileway.ssh.client.transport.hostkey.StrictHostKeyChecking;
import com.jn.agileway.ssh.client.transport.hostkey.knownhosts.KnownHostsFiles;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.logging.Loggers;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;

public class KnownHostsVerifier
implements ServerHostKeyVerifier {
    private static final Logger logger = Loggers.getLogger(KnownHostsVerifier.class);
    private KnownHosts knownHosts = new KnownHosts();
    private final List<File> knownHostsFiles = Collects.emptyArrayList();
    private StrictHostKeyChecking strictHostKeyChecking;
    private static final List<String> supportedAlgorithms = Collects.immutableArrayList((Object[])new String[]{"ssh-dss", "ssh-rsa"});

    public StrictHostKeyChecking getStrictHostKeyChecking() {
        return this.strictHostKeyChecking;
    }

    public void setStrictHostKeyChecking(StrictHostKeyChecking strictHostKeyChecking) {
        this.strictHostKeyChecking = strictHostKeyChecking;
    }

    public KnownHostsVerifier(List<File> files) {
        Collects.forEach(files, (Consumer)new Consumer<File>(){

            public void accept(File file) {
                try {
                    KnownHostsVerifier.this.knownHosts.addHostkeys(file);
                    KnownHostsVerifier.this.knownHostsFiles.add(file);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    public boolean verifyServerHostKey(final String hostname, int port, final String serverHostKeyAlgorithm, final byte[] serverHostKey) throws Exception {
        if (!supportedAlgorithms.contains(serverHostKeyAlgorithm)) {
            return false;
        }
        int result = this.knownHosts.verifyHostkey(hostname, serverHostKeyAlgorithm, serverHostKey);
        if (result == 0) {
            return true;
        }
        if (this.strictHostKeyChecking == StrictHostKeyChecking.NO) {
            if (result == 1) {
                Collects.forEach(this.knownHostsFiles, (Consumer)new Consumer<File>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void accept(File file) {
                        KnownHosts knownHosts = KnownHostsVerifier.this.knownHosts;
                        synchronized (knownHosts) {
                            try {
                                KnownHostsVerifier.this.knownHosts.addHostkey(new String[]{hostname}, serverHostKeyAlgorithm, serverHostKey);
                                KnownHostsFiles.appendHostKeysToFile(file, new String[]{hostname}, serverHostKeyAlgorithm, serverHostKey);
                            }
                            catch (Throwable ex) {
                                logger.error("write to known_hosts file {} fail, error: {}", new Object[]{file.getPath(), ex.getMessage(), ex});
                            }
                        }
                    }
                });
                return true;
            }
            if (result == 2) {
                return true;
            }
            return true;
        }
        return false;
    }
}

