/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.redis.locks;

import com.jn.agileway.redis.core.RedisTemplate;
import com.jn.agileway.redis.locks.LockRandomValueBuilder;
import com.jn.langx.Builder;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.concurrent.lock.DistributedLock;
import java.util.concurrent.TimeUnit;

public class ExclusiveLock
extends DistributedLock {
    private RedisTemplate redisTemplate;
    private String resource;
    private String value;
    private Builder<String> lockRandomValueBuilder = new LockRandomValueBuilder();

    protected String getKey() {
        return this.resource;
    }

    protected Object getValue() {
        String v = this.value;
        if (v == null) {
            v = (String)this.lockRandomValueBuilder.build();
        }
        return v;
    }

    protected void setValue(Object o) {
        this.value = (String)o;
    }

    protected boolean doLock(Object o, long ttl, TimeUnit ttlTime) {
        String expectedValue = (String)o;
        boolean locked = false;
        if (ttl > 0L) {
            Object value = this.redisTemplate.opsForValue().get((Object)this.resource);
            if (value == null) {
                if (ttlTime == null) {
                    ttlTime = TimeUnit.MICROSECONDS;
                }
                if (ttlTime != TimeUnit.MILLISECONDS) {
                    ttl = ttlTime.toMillis(ttl);
                }
                locked = (Boolean)this.redisTemplate.executeScript("SetIfAbsentWithExpireTime", Collects.newArrayList((Object[])new String[]{this.resource}), ttl, value);
            }
        } else {
            locked = this.redisTemplate.opsForValue().setIfAbsent((Object)this.resource, (Object)expectedValue);
        }
        return locked;
    }

    public void forceUnlock() {
        this.unlockOnce(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        if (this.value == null) {
            return;
        }
        long start = System.currentTimeMillis();
        long delta = 3000L;
        long endTime = start + delta;
        boolean unlocked = false;
        while (!unlocked && System.currentTimeMillis() < endTime) {
            unlocked = this.unlockOnce(false);
            if (unlocked) continue;
            try {
                ExclusiveLock exclusiveLock = this;
                synchronized (exclusiveLock) {
                    ((Object)((Object)this)).wait(50L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        if (!unlocked) {
            this.unlockOnce(true);
        }
    }

    private boolean unlockOnce(boolean force) {
        boolean unlocked = false;
        if (this.value == null) {
            this.redisTemplate.delete(this.resource);
            unlocked = true;
        } else {
            unlocked = (Boolean)this.redisTemplate.executeScript("UnlockExclusiveLock", Collects.newArrayList((Object[])new String[]{this.resource}), this.value, force);
        }
        if (unlocked) {
            this.value = null;
        }
        return unlocked;
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public Builder<String> getLockRandomValueBuilder() {
        return this.lockRandomValueBuilder;
    }

    public void setLockRandomValueBuilder(Builder<String> lockRandomValueBuilder) {
        if (lockRandomValueBuilder != null) {
            this.lockRandomValueBuilder = lockRandomValueBuilder;
        }
    }
}

