/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.redis.counter;

import com.jn.agileway.redis.core.RedisTemplate;
import com.jn.agileway.redis.counter.DistributedCounter;

public class HashedDistributedCounter
implements DistributedCounter {
    private RedisTemplate redisTemplate;
    private String key;
    private String counterKey;

    public HashedDistributedCounter(RedisTemplate redisTemplate, String key, String counterKey) {
        this.setRedisTemplate(redisTemplate);
        this.setKey(key);
        this.setCounterKey(counterKey);
    }

    public Long increment() {
        return this.redisTemplate.opsForHash().increment((Object)this.key, (Object)this.counterKey, 1L);
    }

    public Long increment(Long aLong) {
        return this.redisTemplate.opsForHash().increment((Object)this.key, (Object)this.counterKey, aLong.longValue());
    }

    public Long decrement() {
        return this.redisTemplate.opsForHash().increment((Object)this.key, (Object)this.counterKey, -1L);
    }

    public Long decrement(Long aLong) {
        return this.redisTemplate.opsForHash().increment((Object)this.key, (Object)this.counterKey, -aLong.longValue());
    }

    public Long getAndIncrement() {
        return this.getAndIncrement(1L);
    }

    public Long getAndIncrement(Long delta) {
        Long ret = this.get();
        this.increment(delta);
        return ret;
    }

    public Long get() {
        return (Long)this.redisTemplate.opsForHash().get((Object)this.key, (Object)this.counterKey);
    }

    public void set(Long aLong) {
        this.redisTemplate.opsForHash().put((Object)this.key, (Object)this.counterKey, (Object)aLong);
    }

    @Override
    public void clear() {
        this.redisTemplate.opsForHash().delete((Object)this.key, new Object[]{this.counterKey});
    }

    @Override
    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    @Override
    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public String getCounterKey() {
        return this.counterKey;
    }

    @Override
    public void setCounterKey(String key) {
        this.counterKey = key;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }
}

