/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.redis.core.serialization;

import com.jn.agileway.redis.core.key.RedisKeyWrapper;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Preconditions;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class RedisKeySerializer
extends StringRedisSerializer {
    private RedisKeyWrapper keyWrapper = new RedisKeyWrapper();

    public RedisKeySerializer() {
    }

    public RedisKeySerializer(RedisKeyWrapper keyWrapper) {
        this.setKeyWrapper(keyWrapper);
    }

    public RedisKeyWrapper getKeyWrapper() {
        return this.keyWrapper;
    }

    public void setKeyWrapper(RedisKeyWrapper keyWrapper) {
        this.keyWrapper = keyWrapper;
    }

    public byte[] serialize(String key) {
        Preconditions.checkNotNull((Object)key, (String)"key is null");
        key = this.keyWrapper.wrap(key);
        return super.serialize(key);
    }

    public String deserialize(@Nullable byte[] bytes) {
        Preconditions.checkNotEmpty((Object)bytes, (String)"bytes is null");
        String key = super.deserialize(bytes);
        key = this.keyWrapper.unwrap(key);
        return key;
    }
}

