/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.redis.core.serialization;

import com.jn.agileway.codec.Codec;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.codec.CodecException;
import org.springframework.data.redis.serializer.RedisSerializer;

public class DelegatableRedisSerializer<T>
implements RedisSerializer<T> {
    private Codec<T> delegate;

    public DelegatableRedisSerializer() {
    }

    public DelegatableRedisSerializer(Codec<T> delegate) {
        this.setDelegate(delegate);
    }

    public Codec<T> getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Codec<T> delegate) {
        this.delegate = delegate;
    }

    @Nullable
    public byte[] serialize(T obj) throws CodecException {
        return this.delegate.encode(obj);
    }

    @Nullable
    public T deserialize(byte[] bytes) throws CodecException {
        Class<?> targetType = this.getTargetType();
        if (targetType == null) {
            return (T)this.delegate.decode(bytes);
        }
        return (T)this.delegate.decode(bytes, targetType);
    }

    public boolean canSerialize(Class<?> type) {
        return this.delegate.canSerialize(type);
    }

    public Class<?> getTargetType() {
        return this.delegate.getTargetType();
    }
}

