/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.redis.core.script;

import com.jn.agileway.redis.core.script.RedisLuaScript;
import com.jn.langx.configuration.resource.ResourceConfigurationLoader;
import com.jn.langx.io.resource.ClassPathResource;
import com.jn.langx.io.resource.FileResource;
import com.jn.langx.io.resource.Location;
import com.jn.langx.io.resource.Resources;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.logging.Loggers;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class RedisLuaScriptResourceLoader
extends ResourceConfigurationLoader<RedisLuaScript> {
    private static final Logger logger = Loggers.getLogger(RedisLuaScriptResourceLoader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RedisLuaScript load(String configurationId) {
        Location location = this.getResourceLocationProvider().get((Object)configurationId);
        if (location == null) {
            logger.warn("Can't find the location for configuration : {}", (Object)configurationId);
        }
        RedisLuaScript configuration = null;
        com.jn.langx.io.resource.Resource resource = Resources.loadResource((Location)location);
        if (resource != null && resource.exists()) {
            InputStream inputStream = null;
            try {
                inputStream = resource.getInputStream();
                configuration = (RedisLuaScript)this.getParser().parse(inputStream);
                if (configuration == null) return configuration;
                configuration.setId(configurationId);
                Object realResource = resource.getRealResource();
                if (resource instanceof FileResource) {
                    configuration.setLocation((Resource)new FileSystemResource((File)realResource));
                    return configuration;
                }
                if (!(resource instanceof ClassPathResource)) return configuration;
                configuration.setLocation((Resource)new org.springframework.core.io.ClassPathResource(location.getPath()));
                return configuration;
            }
            catch (IOException var7) {
                logger.error(var7.getMessage(), (Throwable)var7);
                return configuration;
            }
            finally {
                IOs.close((Object)inputStream);
            }
        } else {
            logger.error("Location {} is not exists", (Object)location);
        }
        return configuration;
    }
}

