/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.redis.core.script;

import com.jn.agileway.redis.core.script.RedisLuaScript;
import com.jn.langx.configuration.InputStreamConfigurationParser;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Functions;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.function.Predicate2;
import com.jn.langx.util.io.Channels;
import com.jn.langx.util.io.Charsets;
import com.jn.langx.util.struct.Holder;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;

public class RedisLuaScriptParser
implements InputStreamConfigurationParser<RedisLuaScript> {
    private Charset charset = Charsets.UTF_8;
    private static final String RETURN_VALUE_DECLARE_FLAG = "-- @return ";

    public void setEncoding(String charset) {
        if (Strings.isNotBlank((String)charset)) {
            this.charset = Charsets.getCharset((String)charset);
        }
    }

    public RedisLuaScript parse(InputStream inputStream) {
        RedisLuaScript redisScript = new RedisLuaScript();
        Class returnType = this.parseReturnType(inputStream);
        if (returnType != null) {
            redisScript.setResultType(returnType);
        }
        return redisScript;
    }

    private Class parseReturnType(InputStream inputStream) {
        final Holder returnTypeHolder = new Holder();
        Channels.readLines((InputStream)inputStream, (Charset)this.charset, (Predicate2)new Predicate2<Integer, String>(){

            public boolean test(Integer index, String line) {
                return Strings.isNotBlank((String)line) && Strings.startsWith((CharSequence)line, (CharSequence)RedisLuaScriptParser.RETURN_VALUE_DECLARE_FLAG);
            }
        }, (Consumer2)new Consumer2<Integer, String>(){

            public void accept(Integer index, String line) {
                String returnTypeString;
                String comment = line.substring(RedisLuaScriptParser.RETURN_VALUE_DECLARE_FLAG.length());
                if (Strings.isEmpty((String)(comment = Strings.trimOrEmpty((String)comment)))) {
                    return;
                }
                List segments = Pipeline.of((Object[])comment.split(" ,;")).filter(Functions.notEmptyPredicate()).clearNulls().asList();
                if (!segments.isEmpty() && Emptys.isNotEmpty((Object)(returnTypeString = (String)segments.get(0)))) {
                    if (RedisLuaScriptParser.this.isBooleanType(returnTypeString)) {
                        returnTypeHolder.set(Boolean.class);
                    } else if (RedisLuaScriptParser.this.isLongType(returnTypeString)) {
                        returnTypeHolder.set(Long.class);
                    } else if (RedisLuaScriptParser.this.isListType(returnTypeString)) {
                        returnTypeHolder.set(List.class);
                    } else if (RedisLuaScriptParser.this.isObjectType(returnTypeString)) {
                        returnTypeHolder.set(ValueReturnType.class);
                    }
                }
            }
        }, (Predicate2)new Predicate2<Integer, String>(){

            public boolean test(Integer index, String line) {
                return !returnTypeHolder.isEmpty();
            }
        });
        return (Class)returnTypeHolder.get();
    }

    private boolean isBooleanType(final String string) {
        return Pipeline.of((Object[])new String[]{"java.lang.Boolean", "boolean", "bool"}).anyMatch((Predicate)new Predicate<String>(){

            public boolean test(String type) {
                return Strings.equalsIgnoreCase((CharSequence)string, (CharSequence)type);
            }
        });
    }

    private boolean isLongType(final String string) {
        return Pipeline.of((Object[])new String[]{"java.lang.Long", "long"}).anyMatch((Predicate)new Predicate<String>(){

            public boolean test(String type) {
                return Strings.equalsIgnoreCase((CharSequence)string, (CharSequence)type);
            }
        });
    }

    private boolean isListType(final String string) {
        return Pipeline.of((Object[])new String[]{"java.util.List", "list", "table"}).anyMatch((Predicate)new Predicate<String>(){

            public boolean test(String type) {
                return Strings.equalsIgnoreCase((CharSequence)string, (CharSequence)type);
            }
        });
    }

    private boolean isObjectType(final String string) {
        return Pipeline.of((Object[])new String[]{"java.lang.Object", "object"}).anyMatch((Predicate)new Predicate<String>(){

            public boolean test(String type) {
                return Strings.equalsIgnoreCase((CharSequence)string, (CharSequence)type);
            }
        });
    }

    class ValueReturnType {
        ValueReturnType() {
        }
    }
}

