/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.redis.collection;

import com.jn.langx.util.Emptys;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Predicate;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.springframework.data.redis.core.BoundZSetOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.ZSetOperations;

public class RedisSortedSet<E>
implements SortedSet<ZSetOperations.TypedTuple<E>> {
    private BoundZSetOperations ops;
    private String key;
    private final Comparator<? super ZSetOperations.TypedTuple<E>> comparator = new Comparator<ZSetOperations.TypedTuple<E>>(){

        @Override
        public int compare(ZSetOperations.TypedTuple<E> o1, ZSetOperations.TypedTuple<E> o2) {
            double delta = o1.getScore() - o2.getScore();
            if (delta == 0.0) {
                return 0;
            }
            if (delta > 0.0) {
                return 1;
            }
            return -1;
        }
    };

    public RedisSortedSet(RedisOperations<String, E> redisTemplate, String key) {
        this.ops = redisTemplate.boundZSetOps((Object)key);
        this.key = key;
    }

    @Override
    public Comparator<? super ZSetOperations.TypedTuple<E>> comparator() {
        return this.comparator;
    }

    @Override
    public SortedSet<ZSetOperations.TypedTuple<E>> subSet(ZSetOperations.TypedTuple<E> fromElement, ZSetOperations.TypedTuple<E> toElement) {
        TreeSet<ZSetOperations.TypedTuple<E>> set = new TreeSet<ZSetOperations.TypedTuple<E>>(this.comparator);
        set.addAll(this.ops.range(this.ops.rank(fromElement.getValue()).longValue(), this.ops.rank(toElement.getValue()).longValue()));
        return set;
    }

    @Override
    public SortedSet<ZSetOperations.TypedTuple<E>> headSet(ZSetOperations.TypedTuple<E> toElement) {
        ZSetOperations.TypedTuple<E> first = this.first();
        if (first == null) {
            return Collects.emptyTreeSet();
        }
        return this.subSet(first, toElement);
    }

    @Override
    public SortedSet<ZSetOperations.TypedTuple<E>> tailSet(ZSetOperations.TypedTuple<E> fromElement) {
        ZSetOperations.TypedTuple<E> last = this.last();
        if (last == null) {
            return Collects.emptyTreeSet();
        }
        return this.subSet(fromElement, last);
    }

    @Override
    public ZSetOperations.TypedTuple<E> first() {
        Set set = this.ops.rangeWithScores(0L, 0L);
        if (Emptys.isNotEmpty((Object)set)) {
            return (ZSetOperations.TypedTuple)Collects.toArray((Collection)set)[0];
        }
        return null;
    }

    @Override
    public ZSetOperations.TypedTuple<E> last() {
        Set set = this.ops.rangeWithScores(-1L, -1L);
        if (Emptys.isNotEmpty((Object)set)) {
            return (ZSetOperations.TypedTuple)Collects.toArray((Collection)set)[0];
        }
        return null;
    }

    @Override
    public int size() {
        return Long.valueOf(this.longSize()).intValue();
    }

    public long longSize() {
        return this.ops.size();
    }

    @Override
    public boolean isEmpty() {
        return this.longSize() == 0L;
    }

    @Override
    public boolean contains(Object o) {
        return this.ops.rank(((ZSetOperations.TypedTuple)o).getValue()) != null;
    }

    @Override
    public Iterator<ZSetOperations.TypedTuple<E>> iterator() {
        return null;
    }

    @Override
    public Object[] toArray() {
        return this.getAll().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] arr = this.toArray();
        if (a.length >= arr.length) {
            System.arraycopy(arr, 0, a, 0, arr.length);
            return a;
        }
        return arr;
    }

    @Override
    public boolean add(ZSetOperations.TypedTuple<E> tuple) {
        return this.ops.add(tuple.getValue(), tuple.getScore().doubleValue());
    }

    @Override
    public boolean remove(Object o) {
        ZSetOperations.TypedTuple tuple = (ZSetOperations.TypedTuple)o;
        this.ops.remove(new Object[]{tuple.getValue()});
        return true;
    }

    @Override
    public boolean containsAll(Collection c) {
        return Collects.allMatch((Collection)c, (Predicate)new Predicate<ZSetOperations.TypedTuple<E>>(){

            public boolean test(ZSetOperations.TypedTuple<E> tuple) {
                return RedisSortedSet.this.contains(tuple);
            }
        });
    }

    @Override
    public boolean addAll(Collection<? extends ZSetOperations.TypedTuple<E>> c) {
        this.ops.add(Collects.asSet(c));
        return true;
    }

    @Override
    public boolean retainAll(Collection c) {
        final List values = Pipeline.of((Iterable)c).map(new Function<ZSetOperations.TypedTuple<E>, E>(){

            public E apply(ZSetOperations.TypedTuple<E> tuple) {
                return tuple.getValue();
            }
        }).asList();
        if (Emptys.isNotEmpty((Object)values)) {
            this.ops.remove(Pipeline.of(this.getAll()).filter((Predicate)new Predicate<ZSetOperations.TypedTuple>(){

                public boolean test(ZSetOperations.TypedTuple tuple) {
                    return !values.contains(tuple.getValue());
                }
            }).toArray());
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection c) {
        Object[] values = Pipeline.of((Iterable)c).map(new Function<ZSetOperations.TypedTuple<E>, E>(){

            public E apply(ZSetOperations.TypedTuple<E> tuple) {
                return tuple.getValue();
            }
        }).toArray();
        this.ops.remove(values);
        return true;
    }

    private Set<ZSetOperations.TypedTuple> getAll() {
        return this.ops.rangeWithScores(0L, -1L);
    }

    @Override
    public void clear() {
        this.ops.removeRange(0L, -1L);
    }
}

