/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.redis.collection;

import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Predicate;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.RedisOperations;

public class RedisSet<E>
implements Set<E> {
    private BoundSetOperations ops;
    private String key;

    public RedisSet(RedisOperations<String, E> template, String key) {
        this.ops = template.boundSetOps((Object)key);
        this.key = key;
    }

    @Override
    public int size() {
        return Long.valueOf(this.longSize()).intValue();
    }

    public long longSize() {
        return this.ops.size();
    }

    @Override
    public boolean isEmpty() {
        return this.longSize() == 0L;
    }

    @Override
    public boolean contains(Object o) {
        return this.ops.isMember(o);
    }

    @Override
    public Iterator<E> iterator() {
        return new RedisSetIterator();
    }

    @Override
    public Object[] toArray() {
        return this.ops.members().toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return this.ops.members().toArray(a);
    }

    @Override
    public boolean add(E e) {
        this.ops.add(new Object[]{e});
        return true;
    }

    @Override
    public boolean remove(Object o) {
        this.ops.remove(new Object[]{o});
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.ops.members().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Object[] elements = Collects.toArray(c);
        this.ops.add(elements);
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return Collects.allMatch(c, (Predicate)new Predicate(){

            public boolean test(Object o) {
                return RedisSet.this.ops.isMember(o);
            }
        });
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Object[] elements = Collects.toArray(c);
        this.ops.remove(elements);
        return true;
    }

    @Override
    public void clear() {
        this.removeAll(this.ops.members());
    }

    class RedisSetIterator
    implements Iterator {
        List<E> list;
        int index = 0;

        public RedisSetIterator() {
            this.list = Collects.asList((Iterable)RedisSet.this.ops.members());
        }

        @Override
        public boolean hasNext() {
            return !this.list.isEmpty();
        }

        public Object next() {
            return this.list.get(this.index++);
        }

        @Override
        public void remove() {
            if (this.index < this.list.size()) {
                Object obj = this.list.remove(this.index);
                RedisSet.this.ops.remove(new Object[]{obj});
            }
        }
    }
}

