/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.redis.collection;

import com.jn.langx.util.Emptys;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Predicate;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.springframework.data.redis.core.BoundListOperations;
import org.springframework.data.redis.core.RedisOperations;

public class RedisList<E>
implements List<E> {
    private BoundListOperations ops;
    private String key;

    public RedisList(RedisOperations<String, List<E>> redisTemplate, String key) {
        this.key = key;
        this.ops = redisTemplate.boundListOps((Object)key);
    }

    @Override
    public int size() {
        return Long.valueOf(this.ops.size()).intValue();
    }

    public long longSize() {
        return this.ops.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object value) {
        return this.indexOf(value) != -1;
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public Object[] toArray() {
        return this.getAll().toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return this.getAll().toArray(a);
    }

    private Collection<E> getAll() {
        return this.ops.range(0L, -1L);
    }

    @Override
    public boolean add(E e) {
        this.ops.rightPush(e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        this.ops.remove(0L, o);
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return Collects.anyMatch(c, (Predicate)new Predicate(){

            public boolean test(Object value) {
                return RedisList.this.contains(value);
            }
        });
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.ops.rightPushAll(Collects.toArray(c));
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        final E value = this.get(index);
        Collects.forEach(c, (Consumer)new Consumer<E>(){

            public void accept(E e) {
                RedisList.this.ops.leftPush(value, e);
            }
        });
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Collects.forEach(c, (Consumer)new Consumer(){

            public void accept(Object o) {
                RedisList.this.remove(o);
            }
        });
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        final LinkedList retainedList = Collects.emptyLinkedList();
        Collects.forEach(c, (Consumer)new Consumer<E>(){

            public void accept(E e) {
                long removed = RedisList.this.ops.remove(0L, e);
                for (long j = 0L; j < removed; ++j) {
                    retainedList.add(e);
                }
            }
        });
        this.clear();
        this.addAll(retainedList);
        return true;
    }

    @Override
    public void clear() {
        this.ops.trim(0L, -1L);
    }

    @Override
    public E get(int index) {
        return (E)this.ops.index((long)index);
    }

    @Override
    public E set(int index, E element) {
        E old = this.get(index);
        this.ops.set((long)index, element);
        return old;
    }

    @Override
    public void add(int index, E element) {
        E e = this.get(index);
        this.ops.leftPush(e, element);
    }

    @Override
    public E remove(int index) {
        E e = this.get(index);
        List<E> sublist = this.subList(index + 1, -1);
        this.ops.trim((long)index, -1L);
        if (Emptys.isNotEmpty(sublist)) {
            this.addAll(sublist);
        }
        return e;
    }

    @Override
    public int indexOf(Object o) {
        long maxPage;
        long size = this.longSize();
        if (size == 0L) {
            return -1;
        }
        int pageSize = 100;
        int pageNo = 1;
        long l = maxPage = size % (long)pageSize == 0L ? size / (long)pageSize + 1L : size / (long)pageSize;
        while ((long)pageNo <= maxPage) {
            long offset = (pageNo - 1) * pageSize;
            List partition = this.ops.range(offset, offset + (long)pageSize - 1L);
            if (!Emptys.isNotEmpty((Object)partition)) continue;
            int index = partition.indexOf(o);
            if (index >= 0) {
                return Long.valueOf(offset + (long)index).intValue();
            }
            ++pageNo;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        long maxPage;
        long size = this.longSize();
        if (size == 0L) {
            return -1;
        }
        int pageSize = 100;
        long pageNo = maxPage = size % (long)pageSize == 0L ? size / (long)pageSize + 1L : size / (long)pageSize;
        while (pageNo >= 1L) {
            long offset = (pageNo - 1L) * (long)pageSize;
            List partition = this.ops.range(offset, offset + (long)pageSize - 1L);
            if (!Emptys.isNotEmpty((Object)partition)) continue;
            int index = partition.lastIndexOf(o);
            if (index >= 0) {
                return Long.valueOf(offset + (long)index).intValue();
            }
            --pageNo;
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new RedisListIterator(index, this.longSize());
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.ops.range((long)fromIndex, (long)(toIndex - 1));
    }

    class RedisListIterator
    implements ListIterator {
        private int index = 0;
        private long size = 0L;

        RedisListIterator(int index, long size) {
            this.index = index;
            this.size = size;
        }

        @Override
        public boolean hasNext() {
            return (long)this.index < this.size;
        }

        @Override
        public Object next() {
            return RedisList.this.get(this.index++);
        }

        @Override
        public boolean hasPrevious() {
            return true;
        }

        public Object previous() {
            return RedisList.this.get(this.index - 1);
        }

        @Override
        public int nextIndex() {
            return this.index + 1;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            RedisList.this.remove(this.index);
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }
    }
}

