/*
 * Decompiled with CFR 0.152.
 */
package com.berkleytechnologyservices.restdocs.spec.generator.openapi_v3;

import com.berkleytechnologyservices.restdocs.spec.ApiDetails;
import com.berkleytechnologyservices.restdocs.spec.Contact;
import com.berkleytechnologyservices.restdocs.spec.Specification;
import com.berkleytechnologyservices.restdocs.spec.generator.SpecificationGenerator;
import com.berkleytechnologyservices.restdocs.spec.generator.SpecificationGeneratorException;
import com.berkleytechnologyservices.restdocs.spec.generator.SpecificationGeneratorUtils;
import com.epages.restdocs.apispec.model.ResourceModel;
import com.epages.restdocs.apispec.openapi3.OpenApi3Generator;
import io.swagger.v3.oas.models.servers.Server;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;

@Named
public class OpenApi30SpecificationGenerator
implements SpecificationGenerator {
    private final OpenApi3Generator generator;

    public OpenApi30SpecificationGenerator() {
        this(OpenApi3Generator.INSTANCE);
    }

    public OpenApi30SpecificationGenerator(OpenApi3Generator generator) {
        this.generator = generator;
    }

    @Override
    public Specification getSpecification() {
        return Specification.OPENAPI_V3;
    }

    @Override
    public String generate(ApiDetails details, List<ResourceModel> models) throws SpecificationGeneratorException {
        return this.generator.generateAndSerialize(models, this.createServerList(details), details.getName(), details.getDescription(), SpecificationGeneratorUtils.createTagDescriptionsMap(details.getTags()), details.getVersion(), SpecificationGeneratorUtils.createOauth2Configuration(details.getAuthConfig()), details.getFormat().name().toLowerCase(), (io.swagger.v3.oas.models.info.Contact)details.getContact().map(this::toSwaggerContact).orElse(null));
    }

    private List<Server> createServerList(ApiDetails details) throws SpecificationGeneratorException {
        ArrayList<Server> servers = new ArrayList<Server>();
        for (String scheme : details.getSchemes()) {
            try {
                for (String host : details.getHosts()) {
                    URL url = SpecificationGeneratorUtils.createBaseUrl(scheme, host, details.getBasePath() == null ? "" : details.getBasePath());
                    servers.add(new Server().url(url.toString()));
                }
            }
            catch (MalformedURLException e) {
                throw new SpecificationGeneratorException("Unable to build server url.", e);
            }
        }
        return servers;
    }

    private io.swagger.v3.oas.models.info.Contact toSwaggerContact(Contact contact) {
        io.swagger.v3.oas.models.info.Contact swaggerContact = new io.swagger.v3.oas.models.info.Contact();
        return swaggerContact.name(contact.getName()).email(contact.getEmail()).url(contact.getUrl());
    }
}

