/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.time;

import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.randomizers.range.IntegerRangeRandomizer;
import java.time.ZoneOffset;

public class ZoneOffsetRandomizer
implements Randomizer<ZoneOffset> {
    private static final int MAX_SECONDS = 64800;
    private final IntegerRangeRandomizer integerRangeRandomizer;

    public ZoneOffsetRandomizer() {
        this.integerRangeRandomizer = new IntegerRangeRandomizer(-64800, 64800);
    }

    public ZoneOffsetRandomizer(long seed) {
        this.integerRangeRandomizer = new IntegerRangeRandomizer(-64800, 64800, seed);
    }

    public static ZoneOffsetRandomizer aNewZoneOffsetRandomizer() {
        return new ZoneOffsetRandomizer();
    }

    public static ZoneOffsetRandomizer aNewZoneOffsetRandomizer(long seed) {
        return new ZoneOffsetRandomizer(seed);
    }

    @Override
    public ZoneOffset getRandomValue() {
        Integer randomValue = this.integerRangeRandomizer.getRandomValue();
        return ZoneOffset.ofTotalSeconds(randomValue);
    }
}

