/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.time;

import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.randomizers.time.LocalTimeRandomizer;
import io.github.benas.randombeans.randomizers.time.ZoneOffsetRandomizer;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;

public class OffsetTimeRandomizer
implements Randomizer<OffsetTime> {
    private LocalTimeRandomizer localTimeRandomizer;
    private ZoneOffsetRandomizer zoneOffsetRandomizer;

    public OffsetTimeRandomizer() {
        this.localTimeRandomizer = new LocalTimeRandomizer();
        this.zoneOffsetRandomizer = new ZoneOffsetRandomizer();
    }

    public OffsetTimeRandomizer(long seed) {
        this.localTimeRandomizer = new LocalTimeRandomizer(seed);
        this.zoneOffsetRandomizer = new ZoneOffsetRandomizer(seed);
    }

    public static OffsetTimeRandomizer aNewOffsetTimeRandomizer() {
        return new OffsetTimeRandomizer();
    }

    public static OffsetTimeRandomizer aNewOffsetTimeRandomizer(long seed) {
        return new OffsetTimeRandomizer(seed);
    }

    @Override
    public OffsetTime getRandomValue() {
        LocalTime randomLocalTime = this.localTimeRandomizer.getRandomValue();
        ZoneOffset randomZoneOffset = this.zoneOffsetRandomizer.getRandomValue();
        return OffsetTime.of(randomLocalTime, randomZoneOffset);
    }

    public void setLocalTimeRandomizer(LocalTimeRandomizer localTimeRandomizer) {
        this.localTimeRandomizer = localTimeRandomizer;
    }

    public void setZoneOffsetRandomizer(ZoneOffsetRandomizer zoneOffsetRandomizer) {
        this.zoneOffsetRandomizer = zoneOffsetRandomizer;
    }
}

