/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.range;

import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.randomizers.range.LongRangeRandomizer;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class BigDecimalRangeRandomizer
implements Randomizer<BigDecimal> {
    private final LongRangeRandomizer delegate;
    private Integer scale;

    public BigDecimalRangeRandomizer(Long min, Long max) {
        this.delegate = new LongRangeRandomizer(min, max);
    }

    public BigDecimalRangeRandomizer(Long min, Long max, long seed) {
        this.delegate = new LongRangeRandomizer(min, max, seed);
    }

    public BigDecimalRangeRandomizer(Long min, Long max, Integer scale) {
        this.delegate = new LongRangeRandomizer(min, max);
        this.scale = scale;
    }

    public static BigDecimalRangeRandomizer aNewBigDecimalRangeRandomizer(Long min, Long max) {
        return new BigDecimalRangeRandomizer(min, max);
    }

    public static BigDecimalRangeRandomizer aNewBigDecimalRangeRandomizer(Long min, Long max, long seed) {
        return new BigDecimalRangeRandomizer(min, max, seed);
    }

    public static BigDecimalRangeRandomizer aNewBigDecimalRangeRandomizer(Long min, Long max, Integer scale) {
        return new BigDecimalRangeRandomizer(min, max, scale);
    }

    @Override
    public BigDecimal getRandomValue() {
        BigDecimal randomValue = new BigDecimal(this.delegate.getRandomValue());
        if (this.scale != null) {
            randomValue = randomValue.setScale((int)this.scale, RoundingMode.HALF_UP);
        }
        return randomValue;
    }
}

