/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.time;

import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.randomizers.misc.EnumRandomizer;
import io.github.benas.randombeans.randomizers.time.YearRandomizer;
import io.github.benas.randombeans.randomizers.time.internal.DayRandomizer;
import java.time.Month;
import java.time.Period;
import java.time.Year;

public class PeriodRandomizer
implements Randomizer<Period> {
    private final YearRandomizer yearRandomizer;
    private final EnumRandomizer<Month> monthRandomizer;
    private final DayRandomizer dayRandomizer;

    public PeriodRandomizer() {
        this.yearRandomizer = new YearRandomizer();
        this.monthRandomizer = new EnumRandomizer<Month>(Month.class);
        this.dayRandomizer = new DayRandomizer();
    }

    public PeriodRandomizer(long seed) {
        this.yearRandomizer = new YearRandomizer(seed);
        this.monthRandomizer = new EnumRandomizer<Month>(Month.class, seed);
        this.dayRandomizer = new DayRandomizer(seed);
    }

    public static PeriodRandomizer aNewPeriodRandomizer() {
        return new PeriodRandomizer();
    }

    public static PeriodRandomizer aNewPeriodRandomizer(long seed) {
        return new PeriodRandomizer(seed);
    }

    @Override
    public Period getRandomValue() {
        Year randomYear = this.yearRandomizer.getRandomValue();
        Month randomMonth = (Month)this.monthRandomizer.getRandomValue();
        int randomDay = this.dayRandomizer.getRandomValue();
        return Period.of(randomYear.getValue(), randomMonth.getValue(), randomDay);
    }
}

