/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.time;

import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.randomizers.misc.EnumRandomizer;
import io.github.benas.randombeans.randomizers.time.internal.DayRandomizer;
import java.time.Month;
import java.time.MonthDay;

public class MonthDayRandomizer
implements Randomizer<MonthDay> {
    private final EnumRandomizer<Month> monthRandomizer;
    private final DayRandomizer dayRandomizer;

    public MonthDayRandomizer() {
        this.monthRandomizer = new EnumRandomizer<Month>(Month.class);
        this.dayRandomizer = new DayRandomizer();
    }

    public MonthDayRandomizer(long seed) {
        this.monthRandomizer = new EnumRandomizer<Month>(Month.class, seed);
        this.dayRandomizer = new DayRandomizer(seed);
    }

    public static MonthDayRandomizer aNewMonthDayRandomizer() {
        return new MonthDayRandomizer();
    }

    public static MonthDayRandomizer aNewMonthDayRandomizer(long seed) {
        return new MonthDayRandomizer(seed);
    }

    @Override
    public MonthDay getRandomValue() {
        Month randomMonth = (Month)this.monthRandomizer.getRandomValue();
        int randomDay = this.dayRandomizer.getRandomValue();
        return MonthDay.of(randomMonth, randomDay);
    }
}

