/*
 * Decompiled with CFR 0.152.
 */
package com.azhon.appupdate.service;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.widget.Toast;
import com.azhon.appupdate.R;
import com.azhon.appupdate.base.BaseHttpDownloadManager;
import com.azhon.appupdate.base.bean.DownloadStatus;
import com.azhon.appupdate.config.Constant;
import com.azhon.appupdate.listener.OnDownloadListener;
import com.azhon.appupdate.manager.DownloadManager;
import com.azhon.appupdate.manager.HttpDownloadManager;
import com.azhon.appupdate.util.ApkUtil;
import com.azhon.appupdate.util.FileUtil;
import com.azhon.appupdate.util.LogUtil;
import com.azhon.appupdate.util.NotificationUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\tH\u0002J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\tH\u0002J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\"\u0010\u001b\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J\b\u0010\u001e\u001a\u00020\tH\u0002J\b\u0010\u001f\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/azhon/appupdate/service/DownloadService;", "Landroid/app/Service;", "Lcom/azhon/appupdate/listener/OnDownloadListener;", "()V", "lastProgress", "", "manager", "Lcom/azhon/appupdate/manager/DownloadManager;", "cancel", "", "checkApkMd5", "", "done", "apk", "Ljava/io/File;", "download", "downloading", "max", "progress", "error", "e", "", "init", "onBind", "Landroid/os/IBinder;", "intent", "Landroid/content/Intent;", "onStartCommand", "flags", "startId", "releaseResources", "start", "Companion", "appupdate_release"})
public final class DownloadService
extends Service
implements OnDownloadListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private DownloadManager manager;
    private int lastProgress;
    @NotNull
    private static final String TAG = "DownloadService";

    @Nullable
    public IBinder onBind(@Nullable Intent intent) {
        return null;
    }

    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        if (intent == null) {
            return 2;
        }
        this.init();
        return super.onStartCommand(intent, flags, startId);
    }

    private final void init() {
        DownloadManager tempManager = DownloadManager.Companion.getInstance$appupdate_release$default(DownloadManager.Companion, null, 1, null);
        if (tempManager == null) {
            LogUtil.Companion.e(TAG, "An exception occurred by DownloadManager=null,please check your code!");
            return;
        }
        this.manager = tempManager;
        DownloadManager downloadManager = this.manager;
        if (downloadManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
            downloadManager = null;
        }
        FileUtil.Companion.createDirDirectory(downloadManager.getDownloadPath$appupdate_release());
        boolean enable = NotificationUtil.Companion.notificationEnable((Context)this);
        LogUtil.Companion.d(TAG, enable ? "Notification switch status: opened" : "Notification switch status: closed");
        if (this.checkApkMd5()) {
            LogUtil.Companion.d(TAG, "Apk already exist and install it directly.");
            DownloadManager downloadManager2 = this.manager;
            if (downloadManager2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
                downloadManager2 = null;
            }
            String string2 = downloadManager2.getDownloadPath$appupdate_release();
            DownloadManager downloadManager3 = this.manager;
            if (downloadManager3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
                downloadManager3 = null;
            }
            this.done(new File(string2, downloadManager3.getApkName$appupdate_release()));
        } else {
            LogUtil.Companion.d(TAG, "Apk don't exist will start download.");
            this.download();
        }
    }

    private final boolean checkApkMd5() {
        File file;
        DownloadManager downloadManager = this.manager;
        if (downloadManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
            downloadManager = null;
        }
        if (StringsKt.isBlank((CharSequence)downloadManager.getApkMD5$appupdate_release())) {
            return false;
        }
        DownloadManager downloadManager2 = this.manager;
        if (downloadManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
            downloadManager2 = null;
        }
        String string2 = downloadManager2.getDownloadPath$appupdate_release();
        DownloadManager downloadManager3 = this.manager;
        if (downloadManager3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
            downloadManager3 = null;
        }
        if ((file = new File(string2, downloadManager3.getApkName$appupdate_release())).exists()) {
            String string3 = FileUtil.Companion.md5(file);
            DownloadManager downloadManager4 = this.manager;
            if (downloadManager4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
                downloadManager4 = null;
            }
            return StringsKt.equals((String)string3, (String)downloadManager4.getApkMD5$appupdate_release(), (boolean)true);
        }
        return false;
    }

    private final synchronized void download() {
        DownloadManager downloadManager = this.manager;
        if (downloadManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
            downloadManager = null;
        }
        if (downloadManager.getDownloadState()) {
            LogUtil.Companion.e(TAG, "Currently downloading, please download again!");
            return;
        }
        DownloadManager downloadManager2 = this.manager;
        if (downloadManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
            downloadManager2 = null;
        }
        if (downloadManager2.getHttpManager$appupdate_release() == null) {
            DownloadManager downloadManager3;
            DownloadManager downloadManager4 = this.manager;
            if (downloadManager4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
                downloadManager4 = null;
            }
            if ((downloadManager3 = this.manager) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
                downloadManager3 = null;
            }
            downloadManager4.setHttpManager$appupdate_release(new HttpDownloadManager(downloadManager3.getDownloadPath$appupdate_release()));
        }
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)Dispatchers.getMain().plus((CoroutineContext)new CoroutineName("app-update-coroutine")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DownloadService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        DownloadManager downloadManager = DownloadService.access$getManager$p(this.this$0);
                        if (downloadManager == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
                            downloadManager = null;
                        }
                        BaseHttpDownloadManager baseHttpDownloadManager = downloadManager.getHttpManager$appupdate_release();
                        Intrinsics.checkNotNull((Object)baseHttpDownloadManager);
                        DownloadManager downloadManager2 = DownloadService.access$getManager$p(this.this$0);
                        if (downloadManager2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
                            downloadManager2 = null;
                        }
                        String string2 = downloadManager2.getApkUrl$appupdate_release();
                        DownloadManager downloadManager3 = DownloadService.access$getManager$p(this.this$0);
                        if (downloadManager3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
                            downloadManager3 = null;
                        }
                        this.label = 1;
                        Object object3 = baseHttpDownloadManager.download(string2, downloadManager3.getApkName$appupdate_release()).collect(new FlowCollector(this.this$0){
                            final /* synthetic */ DownloadService this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            @Nullable
                            public final Object emit(@NotNull DownloadStatus it, @NotNull Continuation<? super Unit> $completion) {
                                DownloadStatus downloadStatus = it;
                                if (downloadStatus instanceof DownloadStatus.Start) {
                                    this.this$0.start();
                                } else if (downloadStatus instanceof DownloadStatus.Downloading) {
                                    this.this$0.downloading(((DownloadStatus.Downloading)it).getMax(), ((DownloadStatus.Downloading)it).getProgress());
                                } else if (downloadStatus instanceof DownloadStatus.Done) {
                                    this.this$0.done(((DownloadStatus.Done)it).getApk());
                                } else if (downloadStatus instanceof DownloadStatus.Cancel) {
                                    this.this$0.cancel();
                                } else if (downloadStatus instanceof DownloadStatus.Error) {
                                    this.this$0.error(((DownloadStatus.Error)it).getE());
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        DownloadManager downloadManager5 = this.manager;
        if (downloadManager5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
            downloadManager5 = null;
        }
        downloadManager5.setDownloadState(true);
    }

    @Override
    public void start() {
        DownloadManager downloadManager;
        DownloadManager downloadManager2;
        LogUtil.Companion.i(TAG, "download start");
        DownloadManager downloadManager3 = this.manager;
        if (downloadManager3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
            downloadManager3 = null;
        }
        if (downloadManager3.getShowBgdToast$appupdate_release()) {
            Toast.makeText((Context)((Context)this), (int)R.string.app_update_background_downloading, (int)0).show();
        }
        if ((downloadManager2 = this.manager) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
            downloadManager2 = null;
        }
        if (downloadManager2.getShowNotification$appupdate_release()) {
            Context context = (Context)this;
            DownloadManager downloadManager4 = this.manager;
            if (downloadManager4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
                downloadManager4 = null;
            }
            int n = downloadManager4.getSmallIcon$appupdate_release();
            String string2 = this.getResources().getString(R.string.app_update_start_download);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resources.getString(R.st\u2026pp_update_start_download)");
            String string3 = this.getResources().getString(R.string.app_update_start_download_hint);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"resources.getString(R.st\u2026date_start_download_hint)");
            NotificationUtil.Companion.showNotification(context, n, string2, string3);
        }
        if ((downloadManager = this.manager) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
            downloadManager = null;
        }
        Iterable $this$forEach$iv = downloadManager.getOnDownloadListeners$appupdate_release();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OnDownloadListener it = (OnDownloadListener)element$iv;
            boolean bl = false;
            it.start();
        }
    }

    @Override
    public void downloading(int max, int progress) {
        DownloadManager downloadManager;
        DownloadManager downloadManager2 = this.manager;
        if (downloadManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
            downloadManager2 = null;
        }
        if (downloadManager2.getShowNotification$appupdate_release()) {
            int curr = (int)((double)progress / (double)max * 100.0);
            if (curr == this.lastProgress) {
                return;
            }
            LogUtil.Companion.i(TAG, "downloading max: " + max + " --- progress: " + progress);
            this.lastProgress = curr;
            String content = curr < 0 ? "" : "" + curr + '%';
            Context context = (Context)this;
            DownloadManager downloadManager3 = this.manager;
            if (downloadManager3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
                downloadManager3 = null;
            }
            int n = downloadManager3.getSmallIcon$appupdate_release();
            String string2 = this.getResources().getString(R.string.app_update_start_downloading);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resources.getString(R.st\u2026update_start_downloading)");
            NotificationUtil.Companion.showProgressNotification(context, n, string2, content, max == -1 ? -1 : 100, curr);
        }
        if ((downloadManager = this.manager) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
            downloadManager = null;
        }
        Iterable $this$forEach$iv = downloadManager.getOnDownloadListeners$appupdate_release();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OnDownloadListener it = (OnDownloadListener)element$iv;
            boolean bl = false;
            it.downloading(max, progress);
        }
    }

    @Override
    public void done(@NotNull File apk) {
        DownloadManager downloadManager;
        DownloadManager downloadManager2;
        Intrinsics.checkNotNullParameter((Object)apk, (String)"apk");
        LogUtil.Companion.d(TAG, "apk downloaded to " + apk.getPath());
        DownloadManager downloadManager3 = this.manager;
        if (downloadManager3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
            downloadManager3 = null;
        }
        downloadManager3.setDownloadState(false);
        DownloadManager downloadManager4 = this.manager;
        if (downloadManager4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
            downloadManager4 = null;
        }
        if (downloadManager4.getShowNotification$appupdate_release() || Build.VERSION.SDK_INT >= 29) {
            Context context = (Context)this;
            DownloadManager downloadManager5 = this.manager;
            if (downloadManager5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
                downloadManager5 = null;
            }
            int n = downloadManager5.getSmallIcon$appupdate_release();
            String string2 = this.getResources().getString(R.string.app_update_download_completed);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resources.getString(R.st\u2026pdate_download_completed)");
            String string3 = this.getResources().getString(R.string.app_update_click_hint);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"resources.getString(R.st\u2026ng.app_update_click_hint)");
            String string4 = Constant.INSTANCE.getAUTHORITIES();
            Intrinsics.checkNotNull((Object)string4);
            NotificationUtil.Companion.showDoneNotification(context, n, string2, string3, string4, apk);
        }
        if ((downloadManager2 = this.manager) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
            downloadManager2 = null;
        }
        if (downloadManager2.getJumpInstallPage$appupdate_release()) {
            Context context = (Context)this;
            String string5 = Constant.INSTANCE.getAUTHORITIES();
            Intrinsics.checkNotNull((Object)string5);
            ApkUtil.Companion.installApk(context, string5, apk);
        }
        if ((downloadManager = this.manager) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
            downloadManager = null;
        }
        Iterable $this$forEach$iv = downloadManager.getOnDownloadListeners$appupdate_release();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OnDownloadListener it = (OnDownloadListener)element$iv;
            boolean bl = false;
            it.done(apk);
        }
        this.releaseResources();
    }

    @Override
    public void cancel() {
        DownloadManager downloadManager;
        LogUtil.Companion.i(TAG, "download cancel");
        DownloadManager downloadManager2 = this.manager;
        if (downloadManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
            downloadManager2 = null;
        }
        downloadManager2.setDownloadState(false);
        DownloadManager downloadManager3 = this.manager;
        if (downloadManager3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
            downloadManager3 = null;
        }
        if (downloadManager3.getShowNotification$appupdate_release()) {
            NotificationUtil.Companion.cancelNotification((Context)this);
        }
        if ((downloadManager = this.manager) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
            downloadManager = null;
        }
        Iterable $this$forEach$iv = downloadManager.getOnDownloadListeners$appupdate_release();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OnDownloadListener it = (OnDownloadListener)element$iv;
            boolean bl = false;
            it.cancel();
        }
    }

    @Override
    public void error(@NotNull Throwable e) {
        DownloadManager downloadManager;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        LogUtil.Companion.e(TAG, "download error: " + e);
        DownloadManager downloadManager2 = this.manager;
        if (downloadManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
            downloadManager2 = null;
        }
        downloadManager2.setDownloadState(false);
        DownloadManager downloadManager3 = this.manager;
        if (downloadManager3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
            downloadManager3 = null;
        }
        if (downloadManager3.getShowNotification$appupdate_release()) {
            Context context = (Context)this;
            DownloadManager downloadManager4 = this.manager;
            if (downloadManager4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
                downloadManager4 = null;
            }
            int n = downloadManager4.getSmallIcon$appupdate_release();
            String string2 = this.getResources().getString(R.string.app_update_download_error);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resources.getString(R.st\u2026pp_update_download_error)");
            String string3 = this.getResources().getString(R.string.app_update_continue_downloading);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"resources.getString(R.st\u2026ate_continue_downloading)");
            NotificationUtil.Companion.showErrorNotification(context, n, string2, string3);
        }
        if ((downloadManager = this.manager) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
            downloadManager = null;
        }
        Iterable $this$forEach$iv = downloadManager.getOnDownloadListeners$appupdate_release();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OnDownloadListener it = (OnDownloadListener)element$iv;
            boolean bl = false;
            it.error(e);
        }
    }

    private final void releaseResources() {
        DownloadManager downloadManager = this.manager;
        if (downloadManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manager");
            downloadManager = null;
        }
        downloadManager.release$appupdate_release();
        this.stopSelf();
    }

    public static final /* synthetic */ DownloadManager access$getManager$p(DownloadService $this) {
        return $this.manager;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/azhon/appupdate/service/DownloadService$Companion;", "", "()V", "TAG", "", "appupdate_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

