/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.yaml;

import io.github.azagniotov.generics.TypeSafeConverter;
import io.github.azagniotov.stubby4j.annotations.CoberturaIgnore;
import io.github.azagniotov.stubby4j.cli.ANSITerminal;
import io.github.azagniotov.stubby4j.stubs.AbstractBuilder;
import io.github.azagniotov.stubby4j.stubs.ReflectableStub;
import io.github.azagniotov.stubby4j.stubs.StubHttpLifecycle;
import io.github.azagniotov.stubby4j.stubs.StubRequest;
import io.github.azagniotov.stubby4j.stubs.StubResponse;
import io.github.azagniotov.stubby4j.stubs.StubbableAuthorizationType;
import io.github.azagniotov.stubby4j.utils.ConsoleUtils;
import io.github.azagniotov.stubby4j.utils.FileUtils;
import io.github.azagniotov.stubby4j.utils.StringUtils;
import io.github.azagniotov.stubby4j.yaml.ConfigurableYAMLProperty;
import io.github.azagniotov.stubby4j.yaml.SnakeYaml;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YAMLParser {
    static final String FAILED_TO_LOAD_FILE_ERR = "Failed to retrieveLoadedStubs response content using relative path specified in 'file'. Check that response content exists in relative path specified in 'file'";
    private static final Yaml SNAKE_YAML = SnakeYaml.INSTANCE.getSnakeYaml();
    private final AtomicInteger parsedStubCounter = new AtomicInteger();
    private String dataConfigHomeDirectory;

    @CoberturaIgnore
    public List<StubHttpLifecycle> parse(String dataConfigHomeDirectory, String configContent) throws IOException {
        return this.parse(dataConfigHomeDirectory, FileUtils.constructInputStream(configContent));
    }

    @CoberturaIgnore
    public List<StubHttpLifecycle> parse(String dataConfigHomeDirectory, File configFile) throws IOException {
        return this.parse(dataConfigHomeDirectory, FileUtils.constructInputStream(configFile));
    }

    private List<StubHttpLifecycle> parse(String dataConfigHomeDirectory, InputStream configAsStream) throws IOException {
        this.dataConfigHomeDirectory = dataConfigHomeDirectory;
        Object loadedConfig = SNAKE_YAML.load(configAsStream);
        if (!(loadedConfig instanceof List)) {
            throw new IOException("Loaded YAML root node must be an instance of ArrayList, otherwise something went wrong. Check provided YAML");
        }
        LinkedList<StubHttpLifecycle> stubs = new LinkedList<StubHttpLifecycle>();
        List<Map> httpLifecycleConfigs = TypeSafeConverter.asCheckedArrayList(loadedConfig, Map.class);
        for (Map rawHttpLifecycleConfig : httpLifecycleConfigs) {
            Map<String, Object> httpLifecycleProperties = TypeSafeConverter.asCheckedLinkedHashMap(rawHttpLifecycleConfig, String.class, Object.class);
            stubs.add(this.parseStubbedHttpLifecycleConfig(httpLifecycleProperties));
        }
        return stubs;
    }

    private StubHttpLifecycle parseStubbedHttpLifecycleConfig(Map<String, Object> httpLifecycleConfig) {
        StubHttpLifecycle.Builder stubBuilder = new StubHttpLifecycle.Builder();
        for (Map.Entry<String, Object> stubType : httpLifecycleConfig.entrySet()) {
            Object stubTypeValue = stubType.getValue();
            if (stubTypeValue instanceof Map) {
                Map<String, Object> stubbedProperties = TypeSafeConverter.asCheckedLinkedHashMap(stubTypeValue, String.class, Object.class);
                if (this.isRequestProperty(stubType.getKey())) {
                    this.parseStubbedRequestConfig(stubBuilder, stubbedProperties);
                    continue;
                }
                this.parseStubbedResponseConfig(stubBuilder, stubbedProperties);
                continue;
            }
            if (!(stubTypeValue instanceof List)) continue;
            this.parseStubbedResponseListConfig(stubBuilder, stubType);
        }
        return stubBuilder.withCompleteYAML(this.toCompleteYAMLString(httpLifecycleConfig)).withRequestAsYAML(this.toYAMLString(httpLifecycleConfig, ConfigurableYAMLProperty.REQUEST)).withResponseAsYAML(this.toYAMLString(httpLifecycleConfig, ConfigurableYAMLProperty.RESPONSE)).withResourceId(this.parsedStubCounter.getAndIncrement()).build();
    }

    private void parseStubbedRequestConfig(StubHttpLifecycle.Builder stubBuilder, Map<String, Object> requestProperties) {
        StubRequest requestStub = (StubRequest)this.buildReflectableStub(requestProperties, new StubRequest.Builder());
        requestStub.compileRegexPatternsAndCache();
        stubBuilder.withRequest(requestStub);
        ConsoleUtils.logUnmarshalledStubRequest(requestStub.getMethod(), requestStub.getUrl());
    }

    private void parseStubbedResponseConfig(StubHttpLifecycle.Builder stubBuilder, Map<String, Object> responseProperties) {
        StubResponse responseStub = (StubResponse)this.buildReflectableStub(responseProperties, new StubResponse.Builder());
        stubBuilder.withResponse(responseStub);
    }

    private <T extends ReflectableStub, B extends AbstractBuilder<T>> T buildReflectableStub(Map<String, Object> stubbedProperties, B stubTypeBuilder) {
        for (Map.Entry<String, Object> propertyPair : stubbedProperties.entrySet()) {
            String stageableFieldName = propertyPair.getKey();
            this.checkStubbedProperty(stageableFieldName);
            Object rawFieldName = propertyPair.getValue();
            if (rawFieldName instanceof List) {
                stubTypeBuilder.stage(ConfigurableYAMLProperty.ofNullableProperty(stageableFieldName), Optional.of(rawFieldName));
                continue;
            }
            if (rawFieldName instanceof Map) {
                Map<String, String> rawHeaders = TypeSafeConverter.asCheckedLinkedHashMap(rawFieldName, String.class, String.class);
                Map<String, String> headers = this.configureAuthorizationHeader(rawHeaders);
                stubTypeBuilder.stage(ConfigurableYAMLProperty.ofNullableProperty(stageableFieldName), Optional.of(headers));
                continue;
            }
            if (this.isMethodProperty(stageableFieldName)) {
                ArrayList<String> methods = new ArrayList<String>(Collections.singletonList(StringUtils.objectToString(rawFieldName)));
                stubTypeBuilder.stage(ConfigurableYAMLProperty.ofNullableProperty(stageableFieldName), Optional.of(methods));
                continue;
            }
            if (this.isFileProperty(stageableFieldName)) {
                Optional<Object> fileContentOptional = this.loadFileContentFromFileUrl(rawFieldName);
                stubTypeBuilder.stage(ConfigurableYAMLProperty.ofNullableProperty(stageableFieldName), fileContentOptional);
                continue;
            }
            stubTypeBuilder.stage(ConfigurableYAMLProperty.ofNullableProperty(stageableFieldName), Optional.ofNullable(StringUtils.objectToString(rawFieldName)));
        }
        return stubTypeBuilder.build();
    }

    private void parseStubbedResponseListConfig(StubHttpLifecycle.Builder stubBuilder, Map.Entry<String, Object> httpTypeConfig) {
        List<Map> responseProperties = TypeSafeConverter.asCheckedArrayList(httpTypeConfig.getValue(), Map.class);
        stubBuilder.withResponse(this.buildStubResponseList(responseProperties, new StubResponse.Builder()));
    }

    private List<StubResponse> buildStubResponseList(List<Map> responseProperties, StubResponse.Builder stubResponseBuilder) {
        LinkedList<StubResponse> stubResponses = new LinkedList<StubResponse>();
        for (Map rawPropertyPairs : responseProperties) {
            Map<String, Object> propertyPairs = TypeSafeConverter.asCheckedLinkedHashMap(rawPropertyPairs, String.class, Object.class);
            for (Map.Entry<String, Object> propertyPair : propertyPairs.entrySet()) {
                String stageableFieldName = propertyPair.getKey();
                this.checkStubbedProperty(stageableFieldName);
                if (this.isFileProperty(stageableFieldName)) {
                    Optional<Object> fileContentOptional = this.loadFileContentFromFileUrl(propertyPair.getValue());
                    stubResponseBuilder.stage(ConfigurableYAMLProperty.ofNullableProperty(stageableFieldName), fileContentOptional);
                    continue;
                }
                stubResponseBuilder.stage(ConfigurableYAMLProperty.ofNullableProperty(stageableFieldName), Optional.ofNullable(propertyPair.getValue()));
            }
            stubResponses.add(stubResponseBuilder.build());
        }
        return stubResponses;
    }

    private boolean isRequestProperty(String stubbedProperty) {
        return stubbedProperty.toLowerCase().equals(ConfigurableYAMLProperty.REQUEST.toString());
    }

    private boolean isMethodProperty(String stubbedProperty) {
        return stubbedProperty.toLowerCase().equals(ConfigurableYAMLProperty.METHOD.toString());
    }

    private boolean isFileProperty(String stubbedProperty) {
        return stubbedProperty.toLowerCase().equals(ConfigurableYAMLProperty.FILE.toString());
    }

    private Optional<Object> loadFileContentFromFileUrl(Object configPropertyNamedFile) {
        String filePath = StringUtils.objectToString(configPropertyNamedFile);
        try {
            if (FileUtils.isFilePathContainTemplateTokens(new File(filePath))) {
                return Optional.of(new File(this.dataConfigHomeDirectory, filePath));
            }
            return Optional.ofNullable(FileUtils.uriToFile(this.dataConfigHomeDirectory, filePath));
        }
        catch (IOException ex) {
            ANSITerminal.error(ex.getMessage() + " " + FAILED_TO_LOAD_FILE_ERR);
            return Optional.empty();
        }
    }

    private String toCompleteYAMLString(final Map<String, Object> httpLifecycleConfig) {
        ArrayList<Map<String, Object>> root = new ArrayList<Map<String, Object>>(){
            {
                this.add(httpLifecycleConfig);
            }
        };
        return SNAKE_YAML.dumpAs(root, null, DumperOptions.FlowStyle.BLOCK);
    }

    private String toYAMLString(final Map<String, Object> httpLifecycleConfig, final ConfigurableYAMLProperty stubName) {
        HashMap<String, Object> httpType = new HashMap<String, Object>(){
            {
                this.put(stubName.toString(), httpLifecycleConfig.get(stubName.toString()));
            }
        };
        return SNAKE_YAML.dumpAs(httpType, null, DumperOptions.FlowStyle.BLOCK);
    }

    private Map<String, String> configureAuthorizationHeader(Map<String, String> rawHeaders) {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : rawHeaders.entrySet()) {
            String headerValue;
            headers.put(entry.getKey(), entry.getValue());
            if (headers.containsKey(StubbableAuthorizationType.BASIC.asYAMLProp())) {
                headerValue = (String)headers.get(StubbableAuthorizationType.BASIC.asYAMLProp());
                String authorizationHeader = StringUtils.trimIfSet(headerValue);
                String encodedAuthorizationHeader = String.format("%s %s", StubbableAuthorizationType.BASIC.asString(), StringUtils.encodeBase64(authorizationHeader));
                headers.put(StubbableAuthorizationType.BASIC.asYAMLProp(), encodedAuthorizationHeader);
                continue;
            }
            if (headers.containsKey(StubbableAuthorizationType.BEARER.asYAMLProp())) {
                headerValue = (String)headers.get(StubbableAuthorizationType.BEARER.asYAMLProp());
                headers.put(StubbableAuthorizationType.BEARER.asYAMLProp(), String.format("%s %s", StubbableAuthorizationType.BEARER.asString(), StringUtils.trimIfSet(headerValue)));
                continue;
            }
            if (!headers.containsKey(StubbableAuthorizationType.CUSTOM.asYAMLProp())) continue;
            headerValue = (String)headers.get(StubbableAuthorizationType.CUSTOM.asYAMLProp());
            headers.put(StubbableAuthorizationType.CUSTOM.asYAMLProp(), StringUtils.trimIfSet(headerValue));
        }
        return headers;
    }

    private void checkStubbedProperty(String stageableFieldName) {
        if (ConfigurableYAMLProperty.isUnknownProperty(stageableFieldName)) {
            throw new IllegalStateException("An unknown property configured: " + stageableFieldName);
        }
    }
}

