/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.yaml;

import io.github.azagniotov.stubby4j.stubs.StubbableAuthorizationType;
import io.github.azagniotov.stubby4j.utils.FileUtils;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jetty.http.HttpMethod;

public final class YAMLBuilder {
    private static final String TWO_SPACE = String.format("%1$2s", "");
    private static final String THREE_SPACE = String.format("%1$3s", "");
    private static final String SIX_SPACE = String.format("%s%s", THREE_SPACE, THREE_SPACE);
    private static final String NINE_SPACE = String.format("%s%s", SIX_SPACE, THREE_SPACE);
    private static final String TWELVE_SPACE = String.format("%s%s", NINE_SPACE, THREE_SPACE);
    private static final String REQUEST = String.format("-%s%s", TWO_SPACE, "request:");
    private static final String RESPONSE = String.format("%s%s", THREE_SPACE, "response:");
    private static final String HEADERS = String.format("%s%s", SIX_SPACE, "headers:");
    private static final String SEQUENCE_RESPONSE_HEADERS = String.format("%s%s", NINE_SPACE, "headers: ");
    private static final String QUERY = String.format("%s%s", SIX_SPACE, "query:");
    private static final String METHOD = String.format("%s%s", SIX_SPACE, "method: ");
    private static final String TEMP_METHOD_PLACEHOLDER_TOKEN = "METHOD_TOKEN";
    private static final String STATUS = String.format("%s%s", SIX_SPACE, "status: ");
    private static final String SEQUENCE_RESPONSE_STATUS = String.format("%s-%s%s", SIX_SPACE, TWO_SPACE, "status: ");
    private static final String FILE = String.format("%s%s", SIX_SPACE, "file: ");
    private static final String SEQUENCE_RESPONSE_FILE = String.format("%s%s", NINE_SPACE, "file: ");
    private static final String URL = String.format("%s%s", SIX_SPACE, "url: ");
    private static final String ONELINEPOST = String.format("%s%s", SIX_SPACE, "post: ");
    private static final String MULTILINEPOST = String.format("%s%s%s", SIX_SPACE, "post: >", FileUtils.BR);
    private static final String ONELINEBODY = String.format("%s%s", SIX_SPACE, "body: ");
    private static final String SEQUENCE_RESPONSE_ONELINEBODY = String.format("%s%s", NINE_SPACE, "body: ");
    private static final String MULTILINEBODY = String.format("%s%s%s", SIX_SPACE, "body: >", FileUtils.BR);
    private static final String SEQUENCE_RESPONSE_MULTILINEBODY = String.format("%s%s%s", NINE_SPACE, "body: >", FileUtils.BR);
    private static final String NL = FileUtils.BR;
    private static final String REQUEST_HEADERS_KEY = String.format("%s-%s", REQUEST, HEADERS);
    private static final String REQUEST_QUERY_KEY = String.format("%s-%s", REQUEST, QUERY);
    private static final String RESPONSE_HEADERS_KEY = String.format("%s-%s", RESPONSE, HEADERS);
    private static final String RESPONSE_QUERY_KEY = String.format("%s-%s", RESPONSE, QUERY);
    private static final StringBuilder REQUEST_STRING_BUILDER = new StringBuilder();
    private static final StringBuilder RESPONSE_STRING_BUILDER = new StringBuilder();
    final Set<String> storedStubbedMethods = new LinkedHashSet<String>();
    final Set<String> unusedNodes = new HashSet<String>(){
        {
            this.add(REQUEST_HEADERS_KEY);
            this.add(REQUEST_QUERY_KEY);
            this.add(RESPONSE_HEADERS_KEY);
            this.add(RESPONSE_QUERY_KEY);
            this.add(RESPONSE_QUERY_KEY);
        }
    };

    public Request newStubbedRequest() {
        return new Request();
    }

    public final class Response {
        public Response() {
            RESPONSE_STRING_BUILDER.setLength(0);
            RESPONSE_STRING_BUILDER.append(RESPONSE).append(NL);
        }

        public Response withLineBreak() {
            RESPONSE_STRING_BUILDER.append(NL);
            return this;
        }

        public Response withStatus(String value) {
            RESPONSE_STRING_BUILDER.append(STATUS).append(value).append(NL);
            return this;
        }

        public Response withSequenceResponseStatus(String value) {
            RESPONSE_STRING_BUILDER.append(SEQUENCE_RESPONSE_STATUS).append(value).append(NL);
            return this;
        }

        public Response withFile(String value) {
            RESPONSE_STRING_BUILDER.append(FILE).append(value).append(NL);
            return this;
        }

        public Response withSequenceResponseFile(String value) {
            RESPONSE_STRING_BUILDER.append(SEQUENCE_RESPONSE_FILE).append(value).append(NL);
            return this;
        }

        public Response withLiteralBody(String body) {
            RESPONSE_STRING_BUILDER.append(ONELINEBODY).append(body).append(NL);
            return this;
        }

        public Response withSequenceResponseLiteralBody(String body) {
            RESPONSE_STRING_BUILDER.append(SEQUENCE_RESPONSE_ONELINEBODY).append(body).append(NL);
            return this;
        }

        public Response withFoldedBody(String body) {
            String tabbedBody = String.format("%s%s", NINE_SPACE, body);
            RESPONSE_STRING_BUILDER.append(MULTILINEBODY).append(tabbedBody).append(NL);
            return this;
        }

        public Response withSequenceResponseFoldedBody(String body) {
            String tabbedBody = String.format("%s%s", TWELVE_SPACE, body);
            RESPONSE_STRING_BUILDER.append(SEQUENCE_RESPONSE_MULTILINEBODY).append(tabbedBody).append(NL);
            return this;
        }

        public Response withHeaders(String key, String value) {
            if (YAMLBuilder.this.unusedNodes.contains(RESPONSE_HEADERS_KEY)) {
                RESPONSE_STRING_BUILDER.append(HEADERS).append(NL);
                YAMLBuilder.this.unusedNodes.remove(RESPONSE_HEADERS_KEY);
            }
            String tabbedKey = String.format("%s%s: ", NINE_SPACE, key);
            RESPONSE_STRING_BUILDER.append(tabbedKey).append(value).append(NL);
            return this;
        }

        public Response withHeaderContentType(String value) {
            this.checkHeadersNodeRequired();
            String tabbedKey = String.format("%s%s: ", NINE_SPACE, "content-type");
            RESPONSE_STRING_BUILDER.append(tabbedKey).append(value).append(NL);
            return this;
        }

        public Response withHeaderPragma(String value) {
            this.checkHeadersNodeRequired();
            String tabbedKey = String.format("%s%s: ", NINE_SPACE, "pragma");
            RESPONSE_STRING_BUILDER.append(tabbedKey).append(value).append(NL);
            return this;
        }

        public Response withHeaderContentLength(String value) {
            this.checkHeadersNodeRequired();
            String tabbedKey = String.format("%s%s: ", NINE_SPACE, "content-length");
            RESPONSE_STRING_BUILDER.append(tabbedKey).append(value).append(NL);
            return this;
        }

        public Response withHeaderContentLanguage(String value) {
            this.checkHeadersNodeRequired();
            String tabbedKey = String.format("%s%s: ", NINE_SPACE, "content-language");
            RESPONSE_STRING_BUILDER.append(tabbedKey).append(value).append(NL);
            return this;
        }

        public Response withHeaderContentEncoding(String value) {
            this.checkHeadersNodeRequired();
            String tabbedKey = String.format("%s%s: ", NINE_SPACE, "content-encoding");
            RESPONSE_STRING_BUILDER.append(tabbedKey).append(value).append(NL);
            return this;
        }

        public Response withHeaderLocation(String value) {
            this.checkHeadersNodeRequired();
            String tabbedKey = String.format("%s%s: ", NINE_SPACE, "location");
            RESPONSE_STRING_BUILDER.append(tabbedKey).append(value).append(NL);
            return this;
        }

        private void checkHeadersNodeRequired() {
            if (YAMLBuilder.this.unusedNodes.contains(RESPONSE_HEADERS_KEY)) {
                RESPONSE_STRING_BUILDER.append(HEADERS).append(NL);
                YAMLBuilder.this.unusedNodes.remove(RESPONSE_HEADERS_KEY);
            }
        }

        public Response withSequenceResponseHeaders(String key, String value) {
            RESPONSE_STRING_BUILDER.append(SEQUENCE_RESPONSE_HEADERS).append(NL);
            String tabbedKey = String.format("%s%s: ", TWELVE_SPACE, key);
            RESPONSE_STRING_BUILDER.append(tabbedKey).append(value).append(NL);
            return this;
        }

        public String build() {
            String rawRequestString = REQUEST_STRING_BUILDER.toString();
            String cleansedRequestString = rawRequestString.replaceAll(YAMLBuilder.TEMP_METHOD_PLACEHOLDER_TOKEN, YAMLBuilder.this.storedStubbedMethods.toString());
            String yaml = String.format("%s%s%s", cleansedRequestString, NL, RESPONSE_STRING_BUILDER.toString()).trim();
            YAMLBuilder.this.unusedNodes.clear();
            YAMLBuilder.this.unusedNodes.add(REQUEST_HEADERS_KEY);
            YAMLBuilder.this.unusedNodes.add(REQUEST_QUERY_KEY);
            YAMLBuilder.this.unusedNodes.add(RESPONSE_HEADERS_KEY);
            YAMLBuilder.this.unusedNodes.add(RESPONSE_QUERY_KEY);
            YAMLBuilder.this.storedStubbedMethods.clear();
            return yaml;
        }
    }

    public final class Request {
        public Request() {
            REQUEST_STRING_BUILDER.setLength(0);
            REQUEST_STRING_BUILDER.append(REQUEST).append(NL);
        }

        public Request withMethodGet() {
            return this.appendTemporaryMethodPlaceholderStoreMethod(HttpMethod.GET.asString());
        }

        public Request withMethodPut() {
            return this.appendTemporaryMethodPlaceholderStoreMethod(HttpMethod.PUT.asString());
        }

        public Request withMethodPost() {
            return this.appendTemporaryMethodPlaceholderStoreMethod(HttpMethod.POST.asString());
        }

        public Request withMethodHead() {
            return this.appendTemporaryMethodPlaceholderStoreMethod(HttpMethod.HEAD.asString());
        }

        public Request withUrl(String value) {
            REQUEST_STRING_BUILDER.append(URL).append(value).append(NL);
            return this;
        }

        private Request appendTemporaryMethodPlaceholderStoreMethod(String methodName) {
            if (REQUEST_STRING_BUILDER.indexOf(METHOD) == -1) {
                REQUEST_STRING_BUILDER.append(METHOD).append(YAMLBuilder.TEMP_METHOD_PLACEHOLDER_TOKEN).append(NL);
            }
            YAMLBuilder.this.storedStubbedMethods.add(methodName);
            return this;
        }

        public Request withHeaders(String key, String value) {
            this.checkHeadersNodeRequired();
            String tabbedKey = String.format("%s%s: ", NINE_SPACE, key);
            REQUEST_STRING_BUILDER.append(tabbedKey).append(value).append(NL);
            return this;
        }

        public Request withHeaderContentType(String value) {
            this.checkHeadersNodeRequired();
            String tabbedKey = String.format("%s%s: ", NINE_SPACE, "content-type");
            REQUEST_STRING_BUILDER.append(tabbedKey).append(value).append(NL);
            return this;
        }

        public Request withHeaderContentLength(String value) {
            this.checkHeadersNodeRequired();
            String tabbedKey = String.format("%s%s: ", NINE_SPACE, "content-length");
            REQUEST_STRING_BUILDER.append(tabbedKey).append(value).append(NL);
            return this;
        }

        public Request withHeaderContentLanguage(String value) {
            this.checkHeadersNodeRequired();
            String tabbedKey = String.format("%s%s: ", NINE_SPACE, "content-language");
            REQUEST_STRING_BUILDER.append(tabbedKey).append(value).append(NL);
            return this;
        }

        public Request withHeaderContentEncoding(String value) {
            this.checkHeadersNodeRequired();
            String tabbedKey = String.format("%s%s: ", NINE_SPACE, "content-encoding");
            REQUEST_STRING_BUILDER.append(tabbedKey).append(value).append(NL);
            return this;
        }

        public Request withHeaderAuthorizationBasic(String value) {
            this.checkHeadersNodeRequired();
            String tabbedKey = String.format("%s%s: ", NINE_SPACE, StubbableAuthorizationType.BASIC.asYAMLProp());
            REQUEST_STRING_BUILDER.append(tabbedKey).append(value).append(NL);
            return this;
        }

        public Request withHeaderAuthorizationBearer(String value) {
            this.checkHeadersNodeRequired();
            String tabbedKey = String.format("%s%s: ", NINE_SPACE, StubbableAuthorizationType.BEARER.asYAMLProp());
            REQUEST_STRING_BUILDER.append(tabbedKey).append(value).append(NL);
            return this;
        }

        public Request withHeaderAuthorizationCustom(String value) {
            this.checkHeadersNodeRequired();
            String tabbedKey = String.format("%s%s: ", NINE_SPACE, StubbableAuthorizationType.CUSTOM.asYAMLProp());
            REQUEST_STRING_BUILDER.append(tabbedKey).append(value).append(NL);
            return this;
        }

        private void checkHeadersNodeRequired() {
            if (YAMLBuilder.this.unusedNodes.contains(REQUEST_HEADERS_KEY)) {
                REQUEST_STRING_BUILDER.append(HEADERS).append(NL);
                YAMLBuilder.this.unusedNodes.remove(REQUEST_HEADERS_KEY);
            }
        }

        public Request withLiteralPost(String post) {
            REQUEST_STRING_BUILDER.append(ONELINEPOST).append(post).append(NL);
            return this;
        }

        public Request withFoldedPost(String post) {
            String tabbedPost = String.format("%s%s", NINE_SPACE, post);
            REQUEST_STRING_BUILDER.append(MULTILINEPOST).append(tabbedPost).append(NL);
            return this;
        }

        public Request withFile(String value) {
            REQUEST_STRING_BUILDER.append(FILE).append(value).append(NL);
            return this;
        }

        public Request withQuery(String key, String value) {
            if (YAMLBuilder.this.unusedNodes.contains(REQUEST_QUERY_KEY)) {
                REQUEST_STRING_BUILDER.append(QUERY).append(NL);
                YAMLBuilder.this.unusedNodes.remove(REQUEST_QUERY_KEY);
            }
            String tabbedKey = String.format("%s%s: ", NINE_SPACE, key);
            REQUEST_STRING_BUILDER.append(tabbedKey).append(value).append(NL);
            return this;
        }

        public Response newStubbedResponse() {
            return new Response();
        }

        public String toString() {
            return REQUEST_STRING_BUILDER.toString();
        }
    }
}

